/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.ftl;

import io.gitee.jaemon.mocker.exception.MockException;
import io.gitee.jaemon.mocker.core.TemplateContext;

import java.io.File;
import java.util.Map;

import static io.gitee.jaemon.mocker.utils.StringUtils.print;

/**
 * 模板生成
 *
 * @author Jaemon
 * @since 1.0
 */
public abstract class TemplateGenerator<T> implements AutoCloseable {
    protected static final String USER_DIR = System.getProperty("user.dir") + File.separator;
    protected String javaPath = USER_DIR, resourcesPath = USER_DIR;
    protected TemplateContext templateContext;

    public TemplateGenerator(TemplateContext templateContext) {
        this.templateContext = templateContext;
        String projectBaseDir = USER_DIR + "src/main";

        if (new File(projectBaseDir).exists()) {
            javaPath = projectBaseDir + File.separator + "java" +
                    File.separator + templateContext.getBasePackage().replaceAll("\\.", "/") + File.separator;
            resourcesPath = projectBaseDir +
                    File.separator + "resources" + File.separator;
        }
    }

    /**
     * 获取表集合
     *
     * @return
     *      表名-表定义映射
     */
    protected abstract Map<String, T> tables();

    /**
     * 表处理逻辑
     *
     * @param table
     *      表名
     * @param context
     *      定义上下文
     * @throws MockException
     *      ex
     */
    protected abstract void tableProcess(String table, T context) throws MockException;

    public void generate() {
        Map<String, T> tables = tables();
        if (tables.isEmpty()) {
            print("待生成模板的表个数为空!!!");
            return;
        }
        print(". 本次任务待生成模板的表信息%s.", tables.keySet());
        tables.forEach((table, columns) -> {
            print("├── table=%s 开始模板生成啦~~", table);
            tableProcess(table, columns);
            print("├── table=%s 模板生成完成!", table);
        });
        print(". 本次任务共完成%s张表的模板生成.", tables.size());
    }



}