/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.ftl;

import io.gitee.jaemon.mocker.entity.eunms.FileType;

import static io.gitee.jaemon.mocker.common.Constants.TEMPLATE_PREFIX_KEY;

/**
 * TemplateType
 *
 * @author Jaemon
 * @since 1.0
 */
public enum GenerateType {
    ENTITY(
            property("entity", "entity"),
            FileType.JAVA, "ModelTemplate.ftl", true
    ),
    SERVICE(
            property("service", "service"),
            FileType.JAVA, "ServiceTemplate.ftl", true
    ),
    SERVICEIMPL(
            property("serviceImpl", "service.impl"),
            FileType.JAVA, "ServiceImplTemplate.ftl", true
    ),
    DAO(
            property("dao", "mapper"),
            FileType.JAVA, "DaoTemplate.ftl", true
    ),
    MAPPER(
            property("mapper", "mapper"),
            FileType.XML, "MapperTemplate.ftl", true
    ),

    ;

    private String pkgName;
    private FileType type;
    private String freemarker;
    private boolean enabled;

    GenerateType(String pkgName, FileType type, String freemarker, boolean enabled) {
        this.pkgName = pkgName;
        this.type = type;
        this.freemarker = freemarker;
        this.enabled = enabled;
    }

    public String pkgName() {
        return pkgName;
    }

    public FileType type() {
        return type;
    }

    public String freemarker() {
        return freemarker;
    }

    public boolean enabled() {
        return enabled;
    }

    private static String property(String key, String defaultValue) {
        return System.getProperty(TEMPLATE_PREFIX_KEY + key, defaultValue);
    }
}