/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.entity.eunms;

import io.gitee.jaemon.mocker.common.Constants;
import io.gitee.jaemon.mocker.template.ClassGenerator;
import io.gitee.jaemon.mocker.template.clazz.*;

/**
 * TemplateType
 *
 * @author Jaemon
 * @since 1.0
 */
public enum TemplateType {
    ENTITY(
            property("entity", "entity"), new ModelGenerator()
    ),
    SERVICE(
            property("service", "service"), new ServiceGenerator()
    ),
    SERVICEIMPL(
            property("serviceImpl", "service.impl"), new ServiceImplGenerator()
    ),
    DAO(
            property("dao", "mapper"), new DaoGenerator()
    ),
    MAPPER(
            property("mapper", "mapper"), new MapperGenerator()
    ),

    ;

    private String pkgName;
    private ClassGenerator classGenerator;

    TemplateType(String pkgName, ClassGenerator classGenerator) {
        this.pkgName = pkgName;
        this.classGenerator = classGenerator;
    }

    public String pkgName() {
        return pkgName;
    }

    public ClassGenerator classGenerator() {
        return classGenerator;
    }

    private static String property(String key, String defaultValue) {
        return System.getProperty(Constants.TEMPLATE_PREFIX_KEY + key, defaultValue);
    }
}