/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.entity.eunms;

/**
 * 性别
 *
 * @author Jaemon
 * @since 1.0
 */
public enum Gender {
    /** 男性 */
    MALE(new byte[]{1, 3, 5, 7, 9}),
    /** 女性 */
    FEMALE(new byte[]{0, 2, 4, 6, 8}),
    /** 随机 */
    RANDOM(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})
    ;

    public static final Gender[] values = Gender.values();
    private byte[] value;

    Gender(byte[] value) {
        this.value = value;
    }

    public byte[] value() {
        return value;
    }
}