/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.entity;

import io.gitee.jaemon.mocker.template.DataBaseDataType;

/**
 * 字段信息
 *
 * @author Jaemon
 * @since 1.0
 */
public class TemplateColumn {
    private String tableName;
    /** 字段名称 */
    private String columnName;
    /** 字段备注 */
    private String columnComment;
    /** 字段类型 */
    private String columnType;
    /** 是否可为空 */
    private boolean nullable;
    /** 是否为主键 */
    private boolean primaryKey;

    public TemplateColumn(String tableName, String columnName, String columnComment, String columnType, Boolean nullable, Boolean primaryKey) {
        this.tableName = tableName;
        this.columnName = columnName;
        this.columnComment = columnComment;
        this.columnType = columnType;
        this.nullable = nullable == null ? true : nullable;
        this.primaryKey = primaryKey == null ? false : primaryKey;
    }

    public String propertyName() {
        return columnName;
    }

    public String javaType() {
        DataBaseDataType dataBaseDataType = DataBaseDataType.matching(columnType);
        return nullable ? dataBaseDataType.packType() : dataBaseDataType.baseType();
    }

    public String getColumnName() {
        return columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnComment() {
        return columnComment;
    }

    public void setColumnComment(String columnComment) {
        this.columnComment = columnComment;
    }

    public String getColumnType() {
        return columnType;
    }

    public void setColumnType(String columnType) {
        this.columnType = columnType;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean isNullable() {
        return nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isPrimaryKey() {
        return primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }
}