/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.entity;

/**
 * mock日期实体
 *
 * <p>用于工具类
 *
 * @author Jaemon
 * @since 1.0
 */
public class MockDate {
    private int year;
    private String month;
    private String day;

    private MockDate(int year, String month, String day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public static MockDate instance(int year, String month, String day) {
        return new MockDate(year, month, day);
    }

    public String toDate() {
        return new StringBuilder().append(year).append(month).append(day).toString();
    }

    public String toDate(String connector) {
        return new StringBuilder().append(year).append(connector).append(month).append(connector).append(day).toString();
    }

}