/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.entity;

import java.util.List;
import java.util.Map;

/**
 * MockData
 *
 * @author Jaemon
 * @since 1.0
 */
public class MockData {
    /** 表名 */
    private String tableName;
    /** 表字段 */
    private List<String> columns;
    /** 批次起始索引 */
    private int batchStartIndex;
    /** 模拟数据 */
    private List<Map<String, Object>> datas;

    private MockData(
            String tableName, List<String> columns, int batchStartIndex, List<Map<String, Object>> datas
    ) {
        this.tableName = tableName;
        this.columns = columns;
        this.batchStartIndex = batchStartIndex;
        this.datas = datas;
    }

    public static MockData mockData(
            String tableName, List<String> columns, int batchStartIndex, List<Map<String, Object>> datas
    ) {
        return new MockData(tableName, columns, batchStartIndex, datas);
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<String> getColumns() {
        return columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public int getBatchStartIndex() {
        return batchStartIndex;
    }

    public void setBatchStartIndex(int batchStartIndex) {
        this.batchStartIndex = batchStartIndex;
    }

    public List<Map<String, Object>> getDatas() {
        return datas;
    }

    public void setDatas(List<Map<String, Object>> datas) {
        this.datas = datas;
    }
}