/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.entity;

import io.gitee.jaemon.mocker.template.DataBaseDataType;

/**
 * 字段信息
 *
 * @author Jaemon
 * @since 1.0
 */
public class Column {
    /** 字段名称 */
    private String columnName;
    /** 数据类型 */
    private String dataType;
    /** 字段备注 */
    private String columnComment;
    /** 字段序号 */
    private int order;
    /** 数据类型 */
    private DataBaseDataType dataBaseDataType;


    public Column(String columnName, String dataType, String columnComment) {
        this.columnName = columnName;
        this.dataType = dataType;
        this.columnComment = columnComment;
        DataBaseDataType dataBaseDataType = DataBaseDataType.matching(dataType);
        this.dataBaseDataType = dataBaseDataType;
    }

    public Column(String columnName, int order) {
        this.columnName = columnName;
        this.order = order;
    }

    public String getColumnName() {
        return columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnComment() {
        return columnComment;
    }

    public void setColumnComment(String columnComment) {
        this.columnComment = columnComment;
    }

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public int getOrder() {
        return order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public DataBaseDataType getDataBaseDataType() {
        return dataBaseDataType;
    }
}