/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.core;

import io.gitee.jaemon.mocker.entity.eunms.FileType;
import io.gitee.jaemon.mocker.utils.FreemarkerUtils;

import java.io.*;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static io.gitee.jaemon.mocker.core.SqlExecutor.sqlConfig;

/**
 * 字段处理类生成
 *
 * @author Jaemon
 * @since 1.0
 */
public class TemplateGenerator extends ColumnHandlerGenerator {
    private static final String COLUMN_HANDLER_TEMPLATE = "ColumnHandler.ftl";

    public TemplateGenerator(List<String> tables) {
        super(tables);
    }


    @Override
    public String generate(String classPath) {
        String fileName = classPath + File.separator + CLASS_NAME + FileType.JAVA.type();

        boolean hasdate= dbColumns.stream().filter(e -> e.getDataBaseDataType().classType() == Date.class).count() != 0;
        boolean hasBigDecimal = dbColumns.stream().filter(e -> e.getDataBaseDataType().classType() == BigDecimal.class).count() != 0;

        Map<String, Object> dataModel = new HashMap<>();
        dataModel.put("className", CLASS_NAME);
        dataModel.put("columns", dbColumns);
        dataModel.put("author", System.getProperty("user.name", "Jaemon"));
        if (hasdate) {
            dataModel.put("hasDate", true);
        }
        if (hasBigDecimal) {
            dataModel.put("hasBigDecimal", true);
        }

        FreemarkerUtils.generate(fileName, COLUMN_HANDLER_TEMPLATE, dataModel);
        return fileName;
    }

}