/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.core;

/**
 * sql模板工具类
 *
 * @author Jaemon
 * @since 1.0
 */
public final class SqlTemplate {
    static final String TRUNCATE_TABLE_SQL = "truncate table %s";

    /** 查询db所有表名 */
    static final String DB_TABLES_SQL = "" +
            "select table_name\n" +
            "from information_schema.`TABLES`\n" +
            "where table_schema = '%s' %s;";

    /** 查询表的所有字段名 */
    static final String TABLE_COLUMNS_SQL = "" +
            "select column_name, ordinal_position, data_type\n" +
            "from information_schema.`COLUMNS`\n" +
            "where table_schema = '%s' and table_name = '%s' and extra <> 'auto_increment'" +
            "order by ordinal_position;";

    /** 查询DB所有字段类型 */
    static final String DB_COLUMN_TYPES_SQL = "" +
            "select DISTINCT c.data_type\n" +
            "from information_schema.`COLUMNS` c\n" +
            "left join information_schema.`TABLES` t on t.TABLE_NAME = c.table_name \n" +
            "where t.table_schema = '%s';";

    /** 查询DB所有字段名称 */
    static final String DB_COLUMNS_SQL = "" +
            "select column_name, max(data_type) data_type, " +
                "GROUP_CONCAT(" +
                    "table_name, '-', " +
                    "if(column_comment = '', 'null', column_comment), '-', " +
                    "if(column_type = '', 'null', column_type) SEPARATOR '\\t'" +
                ") column_comment \n" +
            "from information_schema.`COLUMNS`\n" +
            "where table_schema = '%s' and extra <> 'auto_increment' %s \n" +
            "group by column_name \n" +
            "order by table_name, ordinal_position;";


    /** 查询DB所有字段信息 */
    public static final String DB_ALL_COLUMNS_SQL = "" +
            "select table_name, column_name, column_comment, data_type, if(is_nullable = 'YES', 1, 0) is_nullable, if(column_key = 'PRI', 1, 0) column_key, column_default\n" +
            "from information_schema.`COLUMNS`\n" +
            "where table_schema = '%s' %s" +
            "order by table_name, ordinal_position";
}