/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.core;

import io.gitee.jaemon.mocker.common.Constants;
import io.gitee.jaemon.mocker.exception.MockException;
import io.gitee.jaemon.mocker.entity.Column;

import java.util.List;
import java.util.Map;

import static io.gitee.jaemon.mocker.core.SqlExecutor.sqlConfig;
import static io.gitee.jaemon.mocker.utils.StringUtils.log;

/**
 * 字段处理生成器
 *
 * @author Jaemon
 * @since 1.0
 */
public abstract class ColumnHandlerGenerator implements AutoCloseable {
    protected static final String CLASS_NAME = Constants.UPPER_UNDERSCORE_CAMEL_CONVERT.convert(sqlConfig.getDb()) + "ColumnHandlerEnum";
    protected List<Column> dbColumns;

    public ColumnHandlerGenerator(List<String> tables) {
        dbColumns = SqlExecutor.dbColumns(tables);

        if (dbColumns.isEmpty()) {
            if (tables.isEmpty()) {
                throw new MockException(
                        log("数据库=%s不存在字段, include=%s, exclude=%s.",
                                sqlConfig.getDb(), sqlConfig.getIncludeTables(), sqlConfig.getExcludeTables()
                        )
                );
            } else {
                throw new MockException(
                        log("数据库=%s不存在字段, tables=%s.",
                                sqlConfig.getDb(), tables
                        )
                );
            }

        }
    }

    /**
     * 生成字段处理类
     *
     * @param classPath
     *      类生成路径, /home/jaemon
     *
     * @return
     *      生成路径
     *      
     * @see io.gitee.jaemon.mocker.TableColumnsHandler#generate(String, Map)
     */
    public abstract String generate(String classPath);

    @Override
    public void close() throws Exception {
        if (SqlExecutor.conn != null) {
            SqlExecutor.conn.close();
        }

        if (dbColumns != null) {
            dbColumns.clear();
        }
    }
}