/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker.annotation;

import io.gitee.jaemon.mocker.TableColumnsHandler;

import java.lang.annotation.*;

/**
 * 字段排序
 *
 * @author Jaemon
 * @since 1.0
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.FIELD})
@Documented
public @interface ColumnOrder {
    /**
     * The order value.
     *
     * <p> the lowest precedence value {@link TableColumnsHandler#LOWEST_PRECEDENCE}
     * <p> the highest precedence value{@link TableColumnsHandler#HIGHEST_PRECEDENCE}
     * <p> Default is {@link TableColumnsHandler#ORDINAL_POSITION}
     *
     * @return
     *      sort no
     */
    int value() default TableColumnsHandler.ORDINAL_POSITION;

    /**
     * 字段排序-优先级高于value
     *
     * @return
     *      字段排序数组
     */
    TableColumn[] order() default {};

}