/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker;

import io.gitee.jaemon.mocker.core.TemplateContext;
import io.gitee.jaemon.mocker.exception.MockException;
import io.gitee.jaemon.mocker.ftl.FreemarkGenerator;
import io.gitee.jaemon.mocker.ftl.TemplateGenerator;
import io.gitee.jaemon.mocker.template.AbstractTemplateGenerator;
import io.gitee.jaemon.mocker.template.MySqlTemplateGenerator;

/**
 * TemplateGeneratorStarter
 *
 * <pre>
 *     System.setProperty("template.generator.entity", "entity");
 *     System.setProperty("template.generator.service", "service");
 *     System.setProperty("template.generator.serviceImpl", "service.impl");
 *     System.setProperty("template.generator.dao", "mapper");
 *     System.setProperty("template.generator.mapper", "mapper");
 * </pre>
 *
 * @author Jaemon
 * @since 1.0
 */
public class TemplateGeneratorStarter {


    /**
     * 生成模板-freemarker方式
     *
     * @param basePackage
     *      包名, <code>io.gitee.jaemon</code>
     */
    public static void create(String basePackage) {
        create(TemplateContext.builder().build(basePackage));
    }

    /**
     * 生成模板-freemarker方式
     *
     * @param context
     *      模板配置信息, {@link TemplateContext}
     */
    public static void create(TemplateContext context) {
        try (
                TemplateGenerator templateGenerator = new FreemarkGenerator(context)
        ) {
            templateGenerator.generate();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }


    /**
     * 生成模板
     *
     * @param basePackage
     *      包名, <code>io.gitee.jaemon</code>
     */
    public static void generate(String basePackage) {
        generate(TemplateContext.builder().build(basePackage));
    }


    /**
     * 生成模板
     *
     * @param context
     *      模板配置信息, {@link TemplateContext}
     */
    public static void generate(TemplateContext context) {
        try {
            AbstractTemplateGenerator templateGenerator = new MySqlTemplateGenerator();
            templateGenerator.generate(context);
        } catch (MockException ex) {
            ex.printStackTrace();
        }
    }

}