/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker;

import java.util.Map;

/**
 * 表字段处理类
 *
 * @author Jaemon
 * @since 1.0
 */
public interface TableColumnsHandler {
    /**
     * Useful constant for the highest precedence value.
     * @see java.lang.Integer#MIN_VALUE
     */
    int HIGHEST_PRECEDENCE = Integer.MIN_VALUE;
    /**
     * Useful constant for the lowest precedence value.
     * @see java.lang.Integer#MAX_VALUE
     */
    int LOWEST_PRECEDENCE = Integer.MAX_VALUE;
    int ORDINAL_POSITION = -1;
    String DEFAULT_TABLE_NAME = "mock_default_table_name_key";

    /**
     * 字段值生成
     *
     * @param tableName
     *          表名
     * @param values
     *          列值数组(key=column_name, value=column_value)
     * @return
     *          字段值
     */
    Object generate(String tableName, Map<String, Object> values);

    /**
     * 字段名称
     *
     * @return
     *      字段名称
     */
    String name();
}