/*
 * Copyright ©2015-2021 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gitee.jaemon.mocker;

import static io.gitee.jaemon.mocker.utils.StringUtils.print;

/**
 * MockerApplication
 *
 * @author Jaemon
 * @since 1.0
 */
public class MockerApplication {

    public static void main(String[] args) {
        String text = "" +
                "// 字段处理类 \n" +
                "DataMockStarter.generate(...);\n" +
                "// 模拟表数据\n" +
                "DataMockStarter.mock(...);\n" +
                "\n" +
                "// 代码生成器-freemarker模板方式(推荐)\n" +
                "TemplateGeneratorStarter.create(...);\n" +
                "// 代码生成器\n" +
                "TemplateGeneratorStarter.generate(...);\n" +
                "\n" +
                "// 模板生成(表对应的实体、接口服务类及实现类、数据库访问层、Mapper映射文件)\n" +
                "TemplateGeneratorStarter.create(...);";

        String config = "" +
                "# 数据库配置\n" +
                "driver=com.mysql.cj.jdbc.Driver\n" +
                "url=jdbc:mysql://localhost:3306/mockdb?useUnicode=true&characterEncoding=utf-8&useSSL=false\n" +
                "username=root\n" +
                "password=root\n" +
                "# 可选(默认false)-执行写入时是否先清空表记录\n" +
                "truncate-table=false\n" +
                "# 可选(默认50)-每张表写入的记录数\n" +
                "record-count=50\n" +
                "# 可选-待处理的表集合,多个以','隔开\n" +
                "include-tables=\n" +
                "# 可选-排除表集合\n" +
                "exclude-tables=\n" +
                "# 可选(默认true)，是否分批写入\n" +
                "in-batches=true";

        print(
                "Welcome to the Mocker.\n\n" +
                "--------------------Usage--------------------\n" +
                "%s" +
                "\n\n" +
                "--------------------默认mocker.properties配置文件参数--------------------\n" +
                "%s",
                text, config);
    }

}