/*
 * Decompiled with CFR 0.152.
 */
package com.jaemon.commons.toolkit.zip;

import com.jaemon.commons.toolkit.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static final Logger log = LoggerFactory.getLogger(ZipUtils.class);

    private ZipUtils() {
    }

    public static void zip(String zipFilePath, List<File> zipFiles) throws ZipException {
        ZipUtils.zip(zipFilePath, zipFiles, null);
    }

    public static void zip(String zipFilePath, List<File> zipFiles, String pwd) throws ZipException {
        ZipFile zipFile;
        zipFiles.removeIf(file -> {
            boolean notExists;
            boolean bl = notExists = !file.exists();
            if (notExists) {
                log.warn("file=[{}] is not exists", (Object)file.getPath());
            }
            return notExists;
        });
        if (zipFiles.size() < 1) {
            log.warn("file size is zero");
            return;
        }
        String zipParentPath = new File(zipFilePath).getParent();
        if (!new File(zipParentPath).exists()) {
            new File(zipParentPath).mkdirs();
        }
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(CompressionMethod.DEFLATE);
        parameters.setCompressionLevel(CompressionLevel.NORMAL);
        if (StringUtils.isEmpty(pwd)) {
            zipFile = new ZipFile(zipFilePath);
        } else {
            zipFile = new ZipFile(zipFilePath, pwd.toCharArray());
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(EncryptionMethod.ZIP_STANDARD);
        }
        zipFile.addFiles(zipFiles, parameters);
        log.info("zipFile is Encrypted={}.", (Object)zipFile.isEncrypted());
    }

    public static void zipSplit(String zipFilePath, List<File> zipFiles) throws ZipException {
        ZipUtils.zipSplit(zipFilePath, zipFiles, 65535L, null);
    }

    public static void zipSplit(String zipFilePath, List<File> zipFiles, String pwd) throws ZipException {
        ZipUtils.zipSplit(zipFilePath, zipFiles, 65535L, pwd);
    }

    public static void zipSplit(String zipFilePath, List<File> zipFiles, long splitLength) throws ZipException {
        ZipUtils.zipSplit(zipFilePath, zipFiles, splitLength, null);
    }

    public static void zipSplit(String zipFilePath, List<File> zipFiles, long splitLength, String pwd) throws ZipException {
        ZipFile zipFile;
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(CompressionMethod.DEFLATE);
        parameters.setCompressionLevel(CompressionLevel.NORMAL);
        String zipParentPath = new File(zipFilePath).getParent();
        if (!new File(zipParentPath).exists()) {
            new File(zipParentPath).mkdirs();
        }
        if (StringUtils.isEmpty(pwd)) {
            zipFile = new ZipFile(zipFilePath);
        } else {
            zipFile = new ZipFile(zipFilePath, pwd.toCharArray());
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(EncryptionMethod.ZIP_STANDARD);
        }
        splitLength = splitLength < 65536L ? 65536L : splitLength;
        zipFile.createSplitZipFile(zipFiles, parameters, true, splitLength);
    }

    public static void zipStream(String zipFilePath, String filePath) throws IOException {
        File file = new File(filePath);
        ZipUtils.zipStream(zipFilePath, file, file.getName(), null);
    }

    public static void zipStreamPwd(String zipFilePath, String filePath, String pwd) throws IOException {
        File file = new File(filePath);
        ZipUtils.zipStream(zipFilePath, file, file.getName(), pwd);
    }

    public static void zipStream(String zipFilePath, String filePath, String fileNameInZip) throws IOException {
        ZipUtils.zipStream(zipFilePath, new File(filePath), fileNameInZip, null);
    }

    public static void zipStream(String zipFilePath, String filePath, String fileNameInZip, String pwd) throws IOException {
        ZipUtils.zipStream(zipFilePath, new File(filePath), fileNameInZip, pwd);
    }

    public static void zipStream(String zipFilePath, File file, String fileNameInZip) throws IOException {
        ZipUtils.zipStream(zipFilePath, file, fileNameInZip, null);
    }

    public static void zipStream(String zipFilePath, File file, String fileNameInZip, String pwd) throws IOException {
        if (!file.exists()) {
            return;
        }
        try (FileInputStream is = new FileInputStream(file);){
            ZipFile zipFile;
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(CompressionMethod.DEFLATE);
            String zipParentPath = new File(zipFilePath).getParent();
            if (!new File(zipParentPath).exists()) {
                new File(zipParentPath).mkdirs();
            }
            if (StringUtils.isEmpty(pwd)) {
                zipFile = new ZipFile(zipFilePath);
            } else {
                zipFile = new ZipFile(zipFilePath, pwd.toCharArray());
                parameters.setEncryptFiles(true);
                parameters.setEncryptionMethod(EncryptionMethod.ZIP_STANDARD);
            }
            fileNameInZip = StringUtils.isNotEmpty(fileNameInZip) ? fileNameInZip : file.getName();
            parameters.setFileNameInZip(fileNameInZip);
            zipFile.addStream((InputStream)is, parameters);
        }
    }

    public static void unzipEn(String srcPath, String descPath) throws ZipException {
        ZipUtils.unzipEn(new File(srcPath), descPath, null);
    }

    public static void unzipEn(String srcPath, String descPath, String pwd) throws ZipException {
        ZipUtils.unzipEn(new File(srcPath), descPath, pwd);
    }

    public static void unzipEn(File srcFile, String descPath) throws ZipException {
        ZipUtils.unzipEn(srcFile, descPath, null);
    }

    public static void unzipEn(File srcFile, String descPath, String pwd) throws ZipException {
        String srcPath = srcFile.getPath();
        if (!srcFile.exists()) {
            log.info("file=[{}] is not exists", (Object)srcPath);
            return;
        }
        ZipFile zipFile = new ZipFile(srcFile);
        if (!zipFile.isValidZipFile()) {
            log.info("file=[{}] is not valid zip file", (Object)srcPath);
            return;
        }
        if (zipFile.isEncrypted()) {
            zipFile = new ZipFile(srcFile, pwd.toCharArray());
        }
        zipFile.extractAll(descPath);
    }

    public static void unzip(String srcPath, String descPath) throws ZipException {
        File file = new File(srcPath);
        ZipUtils.unzip(file, descPath, null);
    }

    public static void unzip(File srcFile, String descPath) throws ZipException {
        ZipUtils.unzip(srcFile, descPath, null);
    }

    public static void unzip(String srcPath, String descPath, String password) throws ZipException {
        File file = new File(srcPath);
        ZipUtils.unzip(file, descPath, password);
    }

    public static void unzip(File srcFile, String descPath, String password) throws ZipException {
        String srcPath = srcFile.getPath();
        if (!srcFile.exists()) {
            log.info("file=[{}] is not exists", (Object)srcPath);
            return;
        }
        ZipFile zipFile = new ZipFile(srcPath);
        if (!zipFile.isValidZipFile()) {
            log.info("file=[{}] is not valid zip file", (Object)srcPath);
            return;
        }
        if (zipFile.isEncrypted()) {
            if (StringUtils.isEmpty(password)) {
                System.out.println("\u8be5\u538b\u7f29\u5305\u8bbe\u7f6e\u4e86\u5bc6\u7801, \u8bf7\u8f93\u5165\u5bc6\u7801");
                return;
            }
            zipFile = new ZipFile(srcFile, password.toCharArray());
        }
        List fileHeaders = zipFile.getFileHeaders();
        for (FileHeader fileHeader : fileHeaders) {
            String fileName = fileHeader.getFileName();
            log.info("fileName=[{}]", (Object)fileName);
            zipFile.extractFile(fileHeader, descPath, fileName);
        }
    }

    private static ZipFile zipFile(File file, String pwd) {
        ZipFile zipFile = StringUtils.isEmpty(pwd) ? new ZipFile(file) : new ZipFile(file, pwd.toCharArray());
        return zipFile;
    }
}

