/*
 * Decompiled with CFR 0.152.
 */
package com.jaemon.commons.toolkit.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class TarUtils {
    private static final String BASE_DIR = "";
    private static final String SYMBOL_DOT = ".";
    private static final String FILE_SUFFIX = ".tar";

    public static void pack(String srcPath) throws Exception {
        TarUtils.pack(new File(srcPath));
    }

    public static void pack(File srcFile) throws Exception {
        String fileName = srcFile.getName() + FILE_SUFFIX;
        String basePath = srcFile.getParent();
        String destPath = basePath + File.separator + fileName;
        TarUtils.pack(srcFile, destPath);
    }

    public static void pack(String srcPath, String destPath) throws Exception {
        File srcFile = new File(srcPath);
        TarUtils.pack(srcFile, destPath);
    }

    public static void pack(File srcFile, File destFile) throws Exception {
        try (TarArchiveOutputStream taos = (TarArchiveOutputStream)new ArchiveStreamFactory().createArchiveOutputStream("tar", (OutputStream)new FileOutputStream(destFile));){
            TarUtils.pack(srcFile, taos, BASE_DIR);
            taos.flush();
        }
    }

    public static void pack(File srcFile, String destPath) throws Exception {
        TarUtils.pack(srcFile, new File(destPath));
    }

    private static void pack(File srcFile, TarArchiveOutputStream taos, String basePath) throws Exception {
        if (srcFile.isDirectory()) {
            TarUtils.packDir(srcFile, taos, basePath);
        } else {
            TarUtils.packFile(srcFile, taos, basePath);
        }
    }

    private static void packDir(File dir, TarArchiveOutputStream taos, String basePath) throws Exception {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        if (files.length < 1) {
            TarArchiveEntry entry = new TarArchiveEntry(basePath + dir.getName() + File.separator);
            taos.putArchiveEntry((ArchiveEntry)entry);
            taos.closeArchiveEntry();
        }
        for (File file : files) {
            TarUtils.pack(file, taos, basePath + dir.getName() + File.separator);
        }
    }

    private static void packFile(File file, TarArchiveOutputStream taos, String dir) throws Exception {
        TarArchiveEntry entry = (TarArchiveEntry)taos.createArchiveEntry(file, dir + file.getName());
        entry.setSize(file.length());
        taos.putArchiveEntry((ArchiveEntry)entry);
        IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)taos);
        taos.closeArchiveEntry();
    }

    public static void unPack(String srcPath) throws Exception {
        TarUtils.unPack(new File(srcPath));
    }

    public static void unPack(File srcFile) throws Exception {
        TarUtils.unPack(srcFile, srcFile.getParent());
    }

    public static void unPack(File srcFile, File destFile) throws Exception {
        try (TarArchiveInputStream tais = new TarArchiveInputStream((InputStream)new FileInputStream(srcFile));){
            TarUtils.unPack(destFile, tais);
        }
    }

    public static void unPack(String srcPath, String destPath) throws Exception {
        TarUtils.unPack(new File(srcPath), destPath);
    }

    public static void unPack(File srcFile, String destPath) throws Exception {
        TarUtils.unPack(srcFile, new File(destPath));
    }

    private static void unPack(File destFile, TarArchiveInputStream tais) throws Exception {
        TarArchiveEntry entry;
        while ((entry = tais.getNextTarEntry()) != null) {
            String dir = destFile.getPath() + File.separator + entry.getName();
            File dirFile = new File(dir);
            TarUtils.mkdirs(dirFile);
            if (entry.isDirectory()) {
                dirFile.mkdirs();
                continue;
            }
            TarUtils.unPackFile(dirFile, tais);
        }
    }

    private static void unPackFile(File destFile, TarArchiveInputStream tais) throws Exception {
        IOUtils.copy((InputStream)tais, (OutputStream)new FileOutputStream(destFile));
    }

    private static void mkdirs(File dirFile) {
        File parentFile = dirFile.getParentFile();
        if (!parentFile.exists()) {
            TarUtils.mkdirs(parentFile);
            parentFile.mkdir();
        }
    }
}

