/*
 * Decompiled with CFR 0.152.
 */
package com.jaemon.commons.toolkit.message.iso8583;

import com.jaemon.commons.toolkit.NumberStringUtil;
import com.jaemon.commons.toolkit.StringUtils;
import com.jaemon.commons.toolkit.exception.Iso8583AnalyzerException;
import com.jaemon.commons.toolkit.message.iso8583.ISO8583Annotation;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class TransISO8583MessageUtil {
    private static final String CHARSET = "GBK";
    private static final String FLD_LENGTH_FLAG_0 = "0";
    private static final String FLD_LENGTH_FLAG_1 = "1";
    private static final String FLD_LENGTH_FLAG_2 = "2";
    private static final String FLD_LENGTH_FLAG_3 = "3";
    private static final String ENCODE_RULE_BCD = "BCD";
    private static final String ENCODE_RULE_HEX = "HEX";
    private static final String ENCODE_RULE_BINARY = "BINARY";
    private static final String FILL_RULE_BEFORE = "BEFORE";
    private static final String FILL_RULE_AFTER = "AFTER";
    private static final String LEN_ENCODE_RULE_ASCII = "ASCII";
    private static final String LEN_ENCODE_RULE_BCD = "BCD";
    private static final String LEN_ENCODE_RULE_HEX = "HEX";
    private static final String LEN_ENCODE_RULE_BINARY = "BINARY";

    private TransISO8583MessageUtil() {
    }

    public static String packISO8583(Object obj, String bitmap, String tpdu, String msgHead, String msgType) throws Exception {
        StringBuilder sendMsg = new StringBuilder();
        sendMsg.append(tpdu).append(msgHead).append(msgType).append(bitmap);
        bitmap = NumberStringUtil.byteToBinary(NumberStringUtil.hexStringToBytes(bitmap));
        Map<Integer, String> iso8583FldMap = TransISO8583MessageUtil.obtISO8583FldMap(obj.getClass());
        String currentFld = "";
        for (int i = 0; i < bitmap.length(); ++i) {
            if (!FLD_LENGTH_FLAG_1.equals(bitmap.substring(i, i + 1))) continue;
            currentFld = iso8583FldMap.get(i + 1);
            String fldHexValue = TransISO8583MessageUtil.getFldHexValue(obj, currentFld);
            sendMsg.append(fldHexValue);
        }
        sendMsg.insert(0, NumberStringUtil.addLeftZero(Integer.toHexString(NumberStringUtil.hexStringToBytes(sendMsg.toString()).length).toUpperCase(), 4));
        return sendMsg.toString();
    }

    public static Object unpackISO8583(Class clazz, String recvMsg) throws Exception {
        return TransISO8583MessageUtil.unpackISO8583(clazz.getName(), recvMsg);
    }

    public static Object unpackISO8583(String className, String recvMsg) throws Exception {
        recvMsg = recvMsg.substring(30, recvMsg.length());
        byte[] recvMsgByte = NumberStringUtil.hexStringToBytes(recvMsg);
        int index = 0;
        int[] indexArr = new int[1];
        byte[] bitTable = NumberStringUtil.getBytes(recvMsgByte, index, 8);
        String bitTableBinary = NumberStringUtil.byteToBinary(bitTable);
        if (FLD_LENGTH_FLAG_1.equals(bitTableBinary.substring(0, 1))) {
            bitTable = NumberStringUtil.getBytes(recvMsgByte, index, 16);
            index += 16;
            bitTableBinary = NumberStringUtil.byteToBinary(bitTable);
        } else {
            index += 8;
        }
        Class<?> clazz = Class.forName(className);
        Object obj = clazz.newInstance();
        Map<Integer, String> iso8583FldMap = TransISO8583MessageUtil.obtISO8583FldMap(clazz);
        indexArr[0] = index;
        for (int i = 1; i < bitTableBinary.length(); ++i) {
            if (!FLD_LENGTH_FLAG_1.equals(bitTableBinary.substring(i, i + 1))) continue;
            String currentFld = iso8583FldMap.get(i + 1);
            String fldValue = TransISO8583MessageUtil.getFldValue(clazz, currentFld, recvMsgByte, indexArr);
            TransISO8583MessageUtil.setFldValue(obj, currentFld, fldValue);
        }
        return obj;
    }

    private static Map<Integer, String> obtISO8583FldMap(Class clazz) throws ClassNotFoundException {
        Field[] fields;
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            boolean fldHasAnnotation = field.isAnnotationPresent(ISO8583Annotation.class);
            if (!fldHasAnnotation) continue;
            ISO8583Annotation fldAnnotation = field.getAnnotation(ISO8583Annotation.class);
            map.put(fldAnnotation.fldIndex(), field.getName());
        }
        return map;
    }

    private static String getFldHexValue(Object obj, String fldName) throws Exception {
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(fldName, obj.getClass());
        String fldValue = (String)propertyDescriptor.getReadMethod().invoke(obj, new Object[0]);
        Field field = obj.getClass().getDeclaredField(fldName);
        boolean fldHasAnnotation = field.isAnnotationPresent(ISO8583Annotation.class);
        if (fldHasAnnotation) {
            ISO8583Annotation fldAnnotation = field.getAnnotation(ISO8583Annotation.class);
            String defaultValue = fldAnnotation.defalutValue();
            fldValue = StringUtils.isNotEmpty(defaultValue) ? defaultValue : TransISO8583MessageUtil.transToHexValue(fldAnnotation, fldValue);
        }
        return fldValue;
    }

    private static String transToHexValue(ISO8583Annotation iso8583Annotation, String fldValue) throws Exception {
        byte[] fldValueBytes = null;
        String fldFlag = iso8583Annotation.fldFlag();
        String encodeRule = iso8583Annotation.encodeRule();
        int dataLength = iso8583Annotation.dataFldLength();
        String fillRule = iso8583Annotation.fillRule();
        String fillChar = iso8583Annotation.fillChar();
        String lenEncodeRule = iso8583Annotation.lenEncodeRule();
        if (FLD_LENGTH_FLAG_1.equals(fldFlag)) {
            int dataLen = "BINARY".equals(encodeRule) ? dataLength * 2 : dataLength;
            fldValue = NumberStringUtil.getByteLengthStr(fldValue, dataLen, CHARSET);
            if (FILL_RULE_BEFORE.equals(fillRule)) {
                String lpad = new String(NumberStringUtil.hexStringToBytes(fillChar), CHARSET);
                fldValue = NumberStringUtil.addLeftChar(fldValue, dataLength, lpad.charAt(0), CHARSET);
            } else if (FILL_RULE_AFTER.equals(fillRule)) {
                String rpad = new String(NumberStringUtil.hexStringToBytes(fillChar), CHARSET);
                fldValue = NumberStringUtil.addRightChar(fldValue, dataLength, rpad.charAt(0), CHARSET);
            }
            fldValueBytes = TransISO8583MessageUtil.fieldEncodeRule(fldValue, CHARSET, encodeRule);
        } else if (FLD_LENGTH_FLAG_2.equals(fldFlag) || FLD_LENGTH_FLAG_3.equals(fldFlag)) {
            int fixLength = fldValue.getBytes(CHARSET).length;
            if ("BINARY".equals(encodeRule)) {
                fixLength = (fixLength + 1) / 2;
            }
            int fldLenSize = FLD_LENGTH_FLAG_2.equals(fldFlag) ? 1 : 2;
            byte[] lengthByte = null;
            if (LEN_ENCODE_RULE_ASCII.equals(lenEncodeRule)) {
                lengthByte = NumberStringUtil.addLeftZero(Integer.toString(fixLength), Integer.parseInt(Integer.toString(fldLenSize))).getBytes(CHARSET);
            } else if ("BCD".equals(lenEncodeRule)) {
                int fldLenSizeTmp = fldLenSize * 2;
                lengthByte = NumberStringUtil.hexStringToBytes(NumberStringUtil.addLeftZero(Integer.toString(fixLength), fldLenSizeTmp));
            } else if ("HEX".equals(lenEncodeRule)) {
                int fldLenSizeTmp = fldLenSize * 2;
                lengthByte = NumberStringUtil.hexStringToBytes(NumberStringUtil.addLeftZero(Integer.toHexString(fixLength), fldLenSizeTmp));
            } else {
                throw new Iso8583AnalyzerException("Error of lenEncodeRule.");
            }
            fldValueBytes = TransISO8583MessageUtil.fieldEncodeRule(fldValue, CHARSET, encodeRule);
            fldValueBytes = NumberStringUtil.byteArrayAdd(lengthByte, fldValueBytes);
        } else if (!FLD_LENGTH_FLAG_0.equals(fldFlag)) {
            throw new Iso8583AnalyzerException("Error of fldFlag.");
        }
        return NumberStringUtil.bytesToHexString(fldValueBytes);
    }

    private static byte[] fieldEncodeRule(String fldValue, String charset, String fldEncodeRule) throws Exception {
        byte[] fieldByte;
        if ("BCD".equals(fldEncodeRule)) {
            if (fldValue.length() % 2 != 0) {
                fldValue = fldValue + FLD_LENGTH_FLAG_0;
            }
            fieldByte = NumberStringUtil.hexStringToBytes(fldValue);
        } else if ("HEX".equals(fldEncodeRule)) {
            String fieldHexStr = Integer.toHexString(Integer.parseInt(fldValue));
            if (fieldHexStr.length() % 2 != 0) {
                fieldHexStr = fieldHexStr + FLD_LENGTH_FLAG_0;
            }
            fieldByte = NumberStringUtil.hexStringToBytes(fieldHexStr);
        } else if ("BINARY".equals(fldEncodeRule)) {
            if (fldValue.length() % 2 != 0) {
                fldValue = fldValue + FLD_LENGTH_FLAG_0;
            }
            fieldByte = NumberStringUtil.hexStringToBytes(fldValue);
        } else {
            fieldByte = fldValue.getBytes(charset);
        }
        return fieldByte;
    }

    private static String getFldValue(Class clazz, String fldName, byte[] byteArray, int[] indexArr) throws Exception {
        String transFldValue = "";
        Field field = clazz.getDeclaredField(fldName);
        boolean fldHasAnnotation = field.isAnnotationPresent(ISO8583Annotation.class);
        if (fldHasAnnotation) {
            ISO8583Annotation fldAnnotation = field.getAnnotation(ISO8583Annotation.class);
            int dataLength = fldAnnotation.dataFldLength();
            String lenEncodeRule = fldAnnotation.lenEncodeRule();
            String fldFlag = fldAnnotation.fldFlag();
            String encodeRule = fldAnnotation.encodeRule();
            if (FLD_LENGTH_FLAG_1.equals(fldFlag)) {
                if ("BCD".equals(encodeRule)) {
                    int fldLen = (dataLength + 1) / 2;
                    byte[] fieldByte = NumberStringUtil.getBytes(byteArray, indexArr[0], fldLen);
                    indexArr[0] = indexArr[0] + fldLen;
                    transFldValue = TransISO8583MessageUtil.fieldDecodeRule(fieldByte, CHARSET, encodeRule);
                    transFldValue = transFldValue.substring(0, dataLength);
                } else {
                    byte[] fieldByte = NumberStringUtil.getBytes(byteArray, indexArr[0], dataLength);
                    indexArr[0] = indexArr[0] + dataLength;
                    transFldValue = TransISO8583MessageUtil.fieldDecodeRule(fieldByte, CHARSET, encodeRule);
                }
            } else if (FLD_LENGTH_FLAG_2.equals(fldFlag) || FLD_LENGTH_FLAG_3.equals(fldFlag)) {
                int lenSize = Integer.parseInt(fldFlag);
                lenSize = (lenSize + 1) / 2;
                byte[] fldLenByte = NumberStringUtil.getBytes(byteArray, indexArr[0], lenSize);
                indexArr[0] = indexArr[0] + lenSize;
                int fieldLength = TransISO8583MessageUtil.fieldLenDecodeRule(fldLenByte, lenEncodeRule);
                if ("BCD".equals(encodeRule)) {
                    byte[] fieldByte = NumberStringUtil.getBytes(byteArray, indexArr[0], (fieldLength + 1) / 2);
                    indexArr[0] = indexArr[0] + (fieldLength + 1) / 2;
                    transFldValue = TransISO8583MessageUtil.fieldDecodeRule(fieldByte, CHARSET, encodeRule);
                    transFldValue = transFldValue.substring(0, fieldLength);
                } else {
                    byte[] fieldByte = NumberStringUtil.getBytes(byteArray, indexArr[0], fieldLength);
                    indexArr[0] = indexArr[0] + fieldLength;
                    transFldValue = TransISO8583MessageUtil.fieldDecodeRule(fieldByte, CHARSET, encodeRule);
                }
            } else if (!FLD_LENGTH_FLAG_0.equals(fldFlag)) {
                throw new Iso8583AnalyzerException("Error of fldFlag.");
            }
        }
        return transFldValue;
    }

    private static void setFldValue(Object obj, String fldName, String fldValue) throws Exception {
        fldName = fldName.substring(0, 1).toUpperCase() + fldName.substring(1);
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(fldName, obj.getClass());
        propertyDescriptor.getWriteMethod().invoke(obj, fldValue);
    }

    private static String fieldDecodeRule(byte[] fieldByte, String charset, String fldEncodeRule) throws Exception {
        String fieldValue;
        if ("BCD".equals(fldEncodeRule)) {
            fieldValue = NumberStringUtil.bytesToHexString(fieldByte);
        } else if ("HEX".equals(fldEncodeRule)) {
            fieldValue = NumberStringUtil.bytesToHexString(fieldByte);
            fieldValue = Integer.toString(Integer.parseInt(fieldValue, 16));
        } else {
            fieldValue = "BINARY".equals(fldEncodeRule) ? NumberStringUtil.bytesToHexString(fieldByte) : new String(fieldByte, charset);
        }
        return fieldValue.trim();
    }

    private static int fieldLenDecodeRule(byte[] fldLenByte, String fldLenEncRule) throws Exception {
        int fieldLength = 0;
        if (LEN_ENCODE_RULE_ASCII.equals(fldLenEncRule)) {
            fieldLength = Integer.parseInt(new String(fldLenByte), 10);
        } else if ("BCD".equals(fldLenEncRule)) {
            fieldLength = Integer.parseInt(NumberStringUtil.bytesToHexString(fldLenByte), 10);
        } else if ("HEX".equals(fldLenEncRule)) {
            fieldLength = Integer.parseInt(NumberStringUtil.bytesToHexString(fldLenByte), 16);
        } else if ("BINARY".equals(fldLenEncRule)) {
            fieldLength = Integer.parseInt(NumberStringUtil.byteToBinary(fldLenByte), 10);
        } else {
            throw new Iso8583AnalyzerException("Error of fieldLenDecodeRule.");
        }
        return fieldLength;
    }
}

