/*
 * Decompiled with CFR 0.152.
 */
package com.jaemon.commons.toolkit;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.jaemon.commons.toolkit.exception.QrCodeException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class QrCodeUtils {
    private static final int DEFAULT_HEIGHT = 500;
    private static final int DEFAULT_WIDTH = 500;

    private QrCodeUtils() {
    }

    public static void encode(File file, String content, String format) throws IOException, WriterException {
        QrCodeUtils.encode(file, 500, 500, content, format);
    }

    public static void encode(File file, int height, int width, String content, String format) throws IOException, WriterException {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>(8);
        hints.put(EncodeHintType.CHARACTER_SET, StandardCharsets.UTF_8.displayName());
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
        hints.put(EncodeHintType.MARGIN, 2);
        BarcodeFormat qrCode = BarcodeFormat.QR_CODE;
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, qrCode, width, height, hints);
        MatrixToImageWriter.writeToPath((BitMatrix)bitMatrix, (String)format, (Path)file.toPath());
    }

    public static void encode(File file, String content, File logoImg) throws IOException, WriterException {
        String fileName = file.getName();
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        QrCodeUtils.encode(file, content, fileType);
        BufferedImage logo = ImageIO.read(file);
        QrCodeUtils.overlapImage(logo, fileType, file, logoImg);
    }

    public static void encode(File file, int height, int width, String content, File logoImg) throws IOException, WriterException {
        String fileName = file.getName();
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        QrCodeUtils.encode(file, height, width, content, fileType);
        BufferedImage logo = ImageIO.read(file);
        QrCodeUtils.overlapImage(logo, fileType, file, logoImg);
    }

    public static String decode(File file) throws IOException, NotFoundException {
        MultiFormatReader formatReader = new MultiFormatReader();
        BufferedImage image = ImageIO.read(file);
        BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new BufferedImageLuminanceSource(image)));
        HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>(2);
        hints.put(EncodeHintType.CHARACTER_SET, StandardCharsets.UTF_8.displayName());
        Result result = formatReader.decode(binaryBitmap, hints);
        return result.getText();
    }

    private static void overlapImage(BufferedImage image, String formatName, File imageFile, File logoFile) {
        try {
            BufferedImage logo = ImageIO.read(logoFile);
            Graphics2D graphics = image.createGraphics();
            int height = image.getHeight() / 6;
            int width = image.getWidth() / 6;
            int x = (image.getWidth() - width) / 2;
            int y = (image.getHeight() - height) / 2;
            graphics.drawImage(logo, x, y, width, height, null);
            graphics.setStroke(new BasicStroke(3.0f));
            graphics.setColor(Color.orange);
            graphics.drawRect(x, y, width, height);
            graphics.dispose();
            ImageIO.write((RenderedImage)image, formatName, imageFile);
        }
        catch (Exception e) {
            throw new QrCodeException(e);
        }
    }
}

