/*
 * Decompiled with CFR 0.152.
 */
package com.jaemon.commons.toolkit;

import com.jaemon.commons.toolkit.enums.ImageFormatEnum;
import com.jaemon.commons.toolkit.exception.PdfOptException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.icepdf.core.exceptions.PDFException;
import org.icepdf.core.exceptions.PDFSecurityException;
import org.icepdf.core.pobjects.Document;

public class PdfUtils {
    private PdfUtils() {
    }

    public static List<String> pdf2Images(String filePath) {
        String descPath = filePath.substring(0, filePath.lastIndexOf("."));
        return PdfUtils.pdf2Images(filePath, descPath);
    }

    public static List<String> pdf2Images(String filePath, String descPath) {
        ArrayList<String> list = new ArrayList<String>();
        File file = new File(filePath);
        try {
            File descFile = new File(descPath);
            if (!descFile.exists()) {
                descFile.mkdirs();
            }
            PDDocument pdf = PDDocument.load((File)file);
            PDFRenderer renderer = new PDFRenderer(pdf);
            int pageCount = pdf.getNumberOfPages();
            for (int i = 0; i < pageCount; ++i) {
                BufferedImage image = renderer.renderImage(i, 1.5f);
                String imagePath = descPath + File.separator + i + ImageFormatEnum.JPG.suffix();
                ImageIO.write((RenderedImage)image, ImageFormatEnum.JPG.format(), new File(imagePath));
                list.add(imagePath);
            }
            pdf.close();
        }
        catch (IOException e) {
            throw new PdfOptException(e);
        }
        return list;
    }

    public static void pdf2Image(String pdfPath, String descPath) {
        try {
            FileInputStream is = new FileInputStream(pdfPath);
            PDDocument pdf = PDDocument.load((InputStream)is);
            int actSize = pdf.getNumberOfPages();
            ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
            for (int i = 0; i < actSize; ++i) {
                BufferedImage image = new PDFRenderer(pdf).renderImageWithDPI(i, 130.0f, ImageType.RGB);
                images.add(image);
            }
            PdfUtils.imagesMerge(images, descPath);
            ((InputStream)is).close();
        }
        catch (IOException e) {
            throw new PdfOptException(e);
        }
    }

    private static void imagesMerge(List<BufferedImage> images, String descPath) {
        if (images == null || images.size() <= 0) {
            System.out.println("\u56fe\u7247\u6570\u7ec4\u4e3a\u7a7a!");
            return;
        }
        try {
            int _height;
            int height = 0;
            int width = 0;
            int imageCnt = images.size();
            int[] heightArray = new int[imageCnt];
            ArrayList<int[]> imgRGB = new ArrayList<int[]>();
            for (int i = 0; i < imageCnt; ++i) {
                BufferedImage buffer = images.get(i);
                heightArray[i] = _height = buffer.getHeight();
                if (i == 0) {
                    width = buffer.getWidth();
                }
                height += _height;
                int[] _imgRGB = new int[width * _height];
                _imgRGB = buffer.getRGB(0, 0, width, _height, _imgRGB, 0, width);
                imgRGB.add(_imgRGB);
            }
            _height = 0;
            BufferedImage imageResult = new BufferedImage(width, height, 1);
            for (int i = 0; i < imageCnt; ++i) {
                int __height = heightArray[i];
                if (i != 0) {
                    _height += __height;
                }
                imageResult.setRGB(0, _height, width, __height, (int[])imgRGB.get(i), 0, width);
            }
            File descFile = new File(descPath);
            ImageIO.write((RenderedImage)imageResult, ImageFormatEnum.JPG.format(), descFile);
        }
        catch (Exception e) {
            throw new PdfOptException(e);
        }
    }

    public static void pdf2Img(String pdfPath, String path, float scale, ImageFormatEnum imageFormat) throws IOException, PDFException, PDFSecurityException {
        Document document = new Document();
        document.setFile(pdfPath);
        float rotation = 0.0f;
        for (int i = 0; i < document.getNumberOfPages(); ++i) {
            BufferedImage image;
            BufferedImage rendImage = image = (BufferedImage)document.getPageImage(i, 1, 3, rotation, scale);
            try {
                String imgName = i + imageFormat.suffix();
                System.out.println(imgName);
                File file = new File(path + imgName);
                ImageIO.write((RenderedImage)rendImage, imageFormat.format(), file);
            }
            catch (IOException e) {
                throw new PdfOptException(e);
            }
            image.flush();
        }
        document.dispose();
    }
}

