/*
 * Decompiled with CFR 0.152.
 */
package com.jaemon.commons.toolkit;

import com.jaemon.commons.toolkit.exception.NumberStringException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class NumberStringUtil {
    private NumberStringUtil() {
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bytes == null || bytes.length <= 0) {
            return "";
        }
        for (byte b : bytes) {
            int v = b & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString().toUpperCase();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || "".equals(hexString)) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(NumberStringUtil.charToByte(hexChars[pos]) << 4 | NumberStringUtil.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static String addLeftZero(String str, int length) {
        int strLength = str.length();
        StringBuilder sb = new StringBuilder(str);
        for (int i = 0; i < length - strLength; ++i) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    public static String addLeftChar(String str, int length, char c, String encode) {
        if (str == null) {
            str = "";
        }
        StringBuilder sb = new StringBuilder(str);
        int strLength = 0;
        try {
            strLength = str.getBytes(encode).length;
        }
        catch (UnsupportedEncodingException e) {
            throw new NumberStringException(e);
        }
        for (int i = 0; i < length - strLength; ++i) {
            sb.insert(0, c);
        }
        return sb.toString();
    }

    public static String addRightChar(String str, int length, char c, String encode) {
        str = str == null ? "" : str;
        StringBuilder sb = new StringBuilder(str);
        int strLength = 0;
        try {
            strLength = str.getBytes(encode).length;
        }
        catch (UnsupportedEncodingException e) {
            throw new NumberStringException(e);
        }
        for (int i = 0; i < length - strLength; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getByteLengthStr(String str, int length, String encode) {
        if (str == null) {
            str = "";
        }
        int strLength = 0;
        try {
            strLength = str.getBytes(encode).length;
        }
        catch (UnsupportedEncodingException e) {
            throw new NumberStringException(e);
        }
        if (strLength <= length) {
            return str;
        }
        byte[] byteTmp = new byte[length];
        String strTmp = "";
        try {
            byte[] strByte = str.getBytes(encode);
            System.arraycopy(strByte, 0, byteTmp, 0, length);
            strTmp = new String(byteTmp, encode);
        }
        catch (UnsupportedEncodingException e) {
            throw new NumberStringException(e);
        }
        return strTmp;
    }

    public static byte[] byteArrayAdd(byte[] sByte, byte[] aByte) {
        byte[] tByte = new byte[sByte.length + aByte.length];
        System.arraycopy(sByte, 0, tByte, 0, sByte.length);
        System.arraycopy(aByte, 0, tByte, sByte.length, aByte.length);
        return tByte;
    }

    public static byte[] getBytes(byte[] byteArray, int index, int length) {
        byte[] getByteArray = new byte[length];
        System.arraycopy(byteArray, index, getByteArray, 0, length);
        return getByteArray;
    }

    public static String byteToBinary(byte[] byteArray) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = byteArray;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int b;
            int z = b = byArray[i];
            String str = Integer.toBinaryString(z |= 0x100);
            int len = str.length();
            sb.append(str, len - 8, len);
        }
        return sb.toString();
    }

    public static InputStream hexToInputStream(String hexString) {
        byte[] bytes = NumberStringUtil.hexStringToBytes(hexString);
        return new ByteArrayInputStream(bytes);
    }
}

