/*
 * Decompiled with CFR 0.152.
 */
package com.jaemon.commons.toolkit;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.imageio.ImageIO;

public class ImageUtils {
    private ImageUtils() {
    }

    public static void shift(File src, String descPath, ShiftEnum shift, int offset) throws IOException {
        String fileName = src.getName();
        String[] fileNameArr = src.getName().split("\\.");
        if (fileNameArr.length != 2) {
            throw new IllegalArgumentException("\u539f\u56fe\u7247\u540d\u79f0\u683c\u5f0f\u5f02\u5e38, \u6ca1\u6709\u56fe\u7247\u540d\u79f0\u540e\u7f00\u540d");
        }
        File desc = new File(descPath + File.separator + fileName);
        ImageUtils.shift(src, desc, shift, offset, fileNameArr[1]);
    }

    public static void shift(File src, File desc, ShiftEnum shift, int offset) throws IOException {
        String[] fileNameArr = src.getName().split("\\.");
        if (fileNameArr.length != 2) {
            throw new IllegalArgumentException("\u539f\u56fe\u7247\u540d\u79f0\u683c\u5f0f\u5f02\u5e38, \u6ca1\u6709\u56fe\u7247\u540d\u79f0\u540e\u7f00\u540d");
        }
        ImageUtils.shift(src, desc, shift, offset, fileNameArr[1]);
    }

    public static void shift(File src, File desc, ShiftEnum shift, int offset, String formatName) throws IOException {
        BufferedImage srcImg = ImageIO.read(src);
        int width = srcImg.getWidth();
        int height = srcImg.getHeight();
        BufferedImage image = new BufferedImage(width, height, 4);
        Graphics2D graphics = image.createGraphics();
        int x = 0;
        int y = 0;
        graphics.setColor(srcImg.getGraphics().getColor());
        graphics.fillRect(x, y, width, height);
        switch (shift) {
            case UP: {
                y -= offset;
                break;
            }
            case DOWN: {
                y += offset;
                break;
            }
            case LEFT: {
                x -= offset;
                break;
            }
            case RIGHT: {
                x += offset;
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageFormat.format("shift={} is invalid.", new Object[]{shift}));
            }
        }
        graphics.drawImage(srcImg, x, y, width, height, null);
        graphics.dispose();
        ImageIO.write((RenderedImage)image, formatName, desc);
    }

    public static void waterMark(File src, File desc, String waterMarkTxt, int fontSize) throws IOException {
        String[] fileNameArr = src.getName().split("\\.");
        if (fileNameArr.length != 2) {
            throw new IllegalArgumentException("\u539f\u56fe\u7247\u540d\u79f0\u683c\u5f0f\u5f02\u5e38, \u6ca1\u6709\u56fe\u7247\u540d\u79f0\u540e\u7f00\u540d");
        }
        BufferedImage srcImg = ImageIO.read(src);
        int width = srcImg.getWidth();
        int height = srcImg.getHeight();
        BufferedImage image = new BufferedImage(width, height, 4);
        Graphics2D graphics = image.createGraphics();
        int x = 0;
        int y = 0;
        graphics.setColor(new Color(223, 223, 223));
        graphics.setFont(new Font("Monospaced", 2, fontSize));
        ((Graphics)graphics).drawString(waterMarkTxt, (width - ImageUtils.length(waterMarkTxt) * fontSize) / 2, height / 2);
        graphics.drawImage(srcImg, x, y, width, height, null);
        graphics.dispose();
        String formatName = fileNameArr[1];
        ImageIO.write((RenderedImage)image, formatName, desc);
    }

    private static int length(String txt) {
        int length = 0;
        for (int i = 0; i < txt.length(); ++i) {
            if (Character.toString(txt.charAt(i)).getBytes().length > 1) {
                length += 2;
                continue;
            }
            ++length;
        }
        return length / 2;
    }

    public static void resize(File src, File desc, double percent) throws IOException {
        String[] fileNameArr = src.getName().split("\\.");
        if (fileNameArr.length != 2) {
            throw new IllegalArgumentException("\u539f\u56fe\u7247\u540d\u79f0\u683c\u5f0f\u5f02\u5e38, \u6ca1\u6709\u56fe\u7247\u540d\u79f0\u540e\u7f00\u540d");
        }
        BufferedImage srcImg = ImageIO.read(src);
        int x = 0;
        int y = 0;
        int width = srcImg.getWidth();
        int height = srcImg.getHeight();
        int newWidth = width * (int)(percent * 100.0) / 100;
        int newHeight = height * (int)(percent * 100.0) / 100;
        BufferedImage image = new BufferedImage(newWidth, newHeight, 4);
        Graphics2D graphics = image.createGraphics();
        graphics.drawImage(srcImg, x, y, newWidth, newHeight, null);
        ImageIO.write((RenderedImage)image, fileNameArr[1], desc);
    }

    private static void screenshot(File srcFile) throws Exception {
        BufferedImage srcImg = ImageIO.read(srcFile);
        int width = srcImg.getWidth() / 5;
        int height = srcImg.getHeight() / 10;
        BufferedImage image = new BufferedImage(width, height, 4);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(srcImg.getGraphics().getColor());
        graphics.fillRect(0, 0, width, height);
        graphics.drawImage(srcImg, 90, 35, srcImg.getWidth(), srcImg.getHeight(), null);
        graphics.setPaintMode();
        graphics.dispose();
        ImageIO.write((RenderedImage)image, "jpg", srcFile);
    }

    public static enum ShiftEnum {
        LEFT,
        RIGHT,
        UP,
        DOWN;

    }
}

