/*
 * Decompiled with CFR 0.152.
 */
package com.jaemon.commons.toolkit;

import com.jaemon.commons.toolkit.StringUtils;
import java.lang.reflect.Field;
import java.util.HashMap;

public class ClassUtils {
    private static final HashMap<String, String> DATA_TYPE_MAPPING = new HashMap();

    public static Field[] superDeclaredField(Class<?> clazz) {
        if (clazz.getSuperclass() != Object.class) {
            Field[] superField = ClassUtils.superDeclaredField(clazz.getSuperclass());
            Field[] currentFields = clazz.getDeclaredFields();
            return StringUtils.addAll(superField, currentFields);
        }
        return clazz.getDeclaredFields();
    }

    public static String toJsonFormat(Class<?> clazz) {
        Field[] fields;
        StringBuilder json = new StringBuilder("{");
        for (Field field : fields = ClassUtils.superDeclaredField(clazz)) {
            String name = field.getName();
            json.append("\"").append(name).append("\": \"%s\",");
        }
        json.deleteCharAt(json.length() - 1);
        json.append("}");
        return json.toString();
    }

    static {
        DATA_TYPE_MAPPING.put("java.lang.Byte", "%d");
        DATA_TYPE_MAPPING.put("byte", "%d");
        DATA_TYPE_MAPPING.put("java.lang.Short", "%d");
        DATA_TYPE_MAPPING.put("short", "%d");
        DATA_TYPE_MAPPING.put("java.lang.Integer", "%d");
        DATA_TYPE_MAPPING.put("int", "%d");
        DATA_TYPE_MAPPING.put("java.lang.Long", "%ld");
        DATA_TYPE_MAPPING.put("long", "%ld");
        DATA_TYPE_MAPPING.put("java.lang.Float", "%f");
        DATA_TYPE_MAPPING.put("float", "%f");
        DATA_TYPE_MAPPING.put("java.lang.Double", "%f");
        DATA_TYPE_MAPPING.put("double", "%f");
        DATA_TYPE_MAPPING.put("java.lang.Boolean", "%b");
        DATA_TYPE_MAPPING.put("boolean", "%b");
        DATA_TYPE_MAPPING.put("java.lang.Character", "%c");
        DATA_TYPE_MAPPING.put("char", "%c");
        DATA_TYPE_MAPPING.put("java.lang.String", "%s");
    }
}

