/*
 * Decompiled with CFR 0.152.
 */
package com.jaemon.commons.toolkit;

import com.jaemon.commons.toolkit.exception.Base64Exception;
import java.io.File;
import java.io.IOException;
import java.util.Base64;
import org.apache.commons.io.FileUtils;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Base64Utils {
    private Base64Utils() {
    }

    public static String encoder(File srcFile) {
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(Base64Utils.file2Bytes(srcFile));
    }

    public static void decoder(String base64Code, File descFile) {
        BASE64Decoder decoder = new BASE64Decoder();
        try {
            byte[] bytes = decoder.decodeBuffer(base64Code);
            Base64Utils.bytes2File(bytes, descFile);
        }
        catch (IOException e) {
            throw new Base64Exception(e);
        }
    }

    public static String jdk8Encoder(File srcFile) {
        return Base64.getEncoder().encodeToString(Base64Utils.file2Bytes(srcFile));
    }

    public static String jdk8MimeEncoder(File srcFile) {
        return Base64.getMimeEncoder().encodeToString(Base64Utils.file2Bytes(srcFile));
    }

    public static String jdk8UrlEncoder(File srcFile) {
        return Base64.getUrlEncoder().encodeToString(Base64Utils.file2Bytes(srcFile));
    }

    public static void jdk8Decoder(String base64Code, File descFile) {
        byte[] bytes = Base64.getDecoder().decode(base64Code);
        Base64Utils.bytes2File(bytes, descFile);
    }

    public static void jdk8MimeDecoder(String base64Code, File descFile) {
        byte[] bytes = Base64.getMimeDecoder().decode(base64Code);
        Base64Utils.bytes2File(bytes, descFile);
    }

    public static void j8UrlDecoder(String base64Code, File descFile) {
        byte[] bytes = Base64.getUrlDecoder().decode(base64Code);
        Base64Utils.bytes2File(bytes, descFile);
    }

    private static byte[] file2Bytes(File srcFile) {
        byte[] bytes;
        try {
            bytes = FileUtils.readFileToByteArray((File)srcFile);
        }
        catch (IOException e) {
            throw new Base64Exception(e);
        }
        return bytes;
    }

    private static void bytes2File(byte[] bytes, File descFile) {
        try {
            FileUtils.writeByteArrayToFile((File)descFile, (byte[])bytes);
        }
        catch (IOException e) {
            throw new Base64Exception(e);
        }
    }
}

