package com.jaemon.commons.toolkit.message.iso8583;

import lombok.Data;

/**
 * <p>
 *     报文交互DTO
 * </p>
 *
 * @author Jaemon
 */
@Data
public class ISO8583 {

    /** 2域-主账号 */
    @ISO8583Annotation(
            fldIndex = 2, dataFldLength = 19, encodeRule = "BCD", fldFlag = "2"
    )
    private String cardNo02;

    /** 3域-交易处理码 */
    @ISO8583Annotation(
            fldIndex = 3, dataFldLength = 6, encodeRule = "BCD", fldFlag = "1",
            fillRule = "BEFORE", fillChar = "30"
    )
    private String transProcCode03;

    /** 4域-交易金额 */
    @ISO8583Annotation(
            fldIndex = 4, dataFldLength = 12, encodeRule = "BCD", fldFlag = "1",
            fillRule = "BEFORE", fillChar = "30"
    )
    private String transAmt04;

    /** 11域-受卡方系统跟踪号 */
    @ISO8583Annotation(
            fldIndex = 11, dataFldLength = 6, encodeRule = "BCD", fldFlag = "1",
            fillRule = "BEFORE", fillChar = "30"
    )
    private String sysTrackNo11;

    /** 12域-受卡方所在地时间 */
    @ISO8583Annotation(
            fldIndex = 12, dataFldLength = 6, encodeRule = "BCD", fldFlag = "1",
            fillRule = "BEFORE", fillChar = "30"
    )
    private String locTime12;

    /** 13域-受卡方所在地日期 */
    @ISO8583Annotation(
            fldIndex = 13, dataFldLength = 4, encodeRule = "BCD", fldFlag = "1",
            fillRule = "BEFORE", fillChar = "30"
    )
    private String locDate13;

    /** 14域-卡有效期 */
    @ISO8583Annotation(
            fldIndex = 14, dataFldLength = 4, encodeRule = "BCD", fldFlag = "1",
            fillRule = "BEFORE", fillChar = "30"
    )
    private String expireDate14;

    /** 15域-清算日期 */
    @ISO8583Annotation(
            fldIndex = 15, dataFldLength = 4, encodeRule = "BCD", fldFlag = "1",
            fillRule = "BEFORE", fillChar = "30"
    )
    private String liquidatimeDate15;

    /** 22域-服务点输入方式码 */
    @ISO8583Annotation(
            fldIndex = 22, dataFldLength = 3, encodeRule = "BCD", fldFlag = "1",
            fillRule = "BEFORE", fillChar = "30"
    )
    private String serviceInputModeCode22;

    /** 23域-卡片序列号 */
    @ISO8583Annotation(
            fldIndex = 23, dataFldLength = 3, encodeRule = "BCD", fldFlag = "1",
            fillRule = "BEFORE", fillChar = "30"
    )
    private String cardSerialNo23;

    /** 25域-服务点条件码 */
    @ISO8583Annotation(
            fldIndex = 25, dataFldLength = 2, encodeRule = "BCD", fldFlag = "1",
            fillRule = "BEFORE", fillChar = "30"
    )
    private String serviceConditionCode25;

    /** 26域-服务点PIN获取码 */
    @ISO8583Annotation(
            fldIndex = 26, dataFldLength = 2, encodeRule = "BCD", fldFlag = "1",
            fillRule = "BEFORE", fillChar = "30"
    )
    private String servicePINAccessCode26;

    /** 32域-受理方标识码 */
    @ISO8583Annotation(
            fldIndex = 32, dataFldLength = 11, encodeRule = "BCD", fldFlag = "2",
            defalutValue = ""
    )
    private String acquirerMarkCode32;

    /** 35域-2磁道数据 */
    @ISO8583Annotation(
            fldIndex = 35, dataFldLength = 37, encodeRule = "BCD", fldFlag = "2"
    )
    private String track2Data35;

    /** 36域-3磁道数据 */
    @ISO8583Annotation(
            fldIndex = 36, dataFldLength = 999, encodeRule = "BCD", fldFlag = "3"
    )
    private String track3Data36;

    /** 37域-检索参考号 */
    @ISO8583Annotation(
            fldIndex = 37, dataFldLength = 12, encodeRule = "ASCII", fldFlag = "1",
            fillRule = "AFTER", fillChar = "20"
    )
    private String retrievalReferenceNo37;

    /** 38域-授权标识应答码 */
    @ISO8583Annotation(
            fldIndex = 38, dataFldLength = 6, encodeRule = "ASCII", fldFlag = "1",
            fillRule = "AFTER", fillChar = "20"
    )
    private String authIdentityRespCode38;

    /** 39域-应答码 */
    @ISO8583Annotation(
            fldIndex = 39, dataFldLength = 2, encodeRule = "ASCII", fldFlag = "1",
            fillRule = "AFTER", fillChar = "20"
    )
    private String respCode39;

    /** 40域-应答描述 */
    @ISO8583Annotation(
            fldIndex = 40, dataFldLength = 99, encodeRule = "ASCII", fldFlag = "2"
    )
    private String respDesc40;

    /** 41域-受卡机终端标识码 */
    @ISO8583Annotation(
            fldIndex = 41, dataFldLength = 18, encodeRule = "ASCII", fldFlag = "1",
            fillRule = "AFTER", fillChar = "20"
    )
    private String cardAcceptorTerminalID41;

    /** 42域-受卡方标识码 */
    @ISO8583Annotation(
            fldIndex = 42, dataFldLength = 15, encodeRule = "ASCII", fldFlag = "1",
            fillRule = "AFTER", fillChar = "20"
    )
    private String cardAcceptorID42;

    /** 44域-附加响应数据 */
    @ISO8583Annotation(
            fldIndex = 44, dataFldLength = 25, encodeRule = "ASCII", fldFlag = "2"
    )
    private String additionalRespData44;

    /** 48域-附加数据-私有 */
    @ISO8583Annotation(
            fldIndex = 48, dataFldLength = 322, encodeRule = "BCD", fldFlag = "3"
    )
    private String additionalDataPrivate48;

    /** 49域-交易货币代码 */
    @ISO8583Annotation(
            fldIndex = 49, dataFldLength = 3, encodeRule = "ASCII", fldFlag = "1",
            fillRule = "AFTER", fillChar = "20"
    )
    private String currencyCode49;

    /** 52域-个人标识码数据 */
    @ISO8583Annotation(
            fldIndex = 52, dataFldLength = 8, encodeRule = "BINARY", fldFlag = "1",
            fillRule = "BEFORE", fillChar = "30"
    )
    private String personalIDCodeData52;

    /** 53域-安全控制信息 */
    @ISO8583Annotation(
            fldIndex = 53, dataFldLength = 16, encodeRule = "BCD", fldFlag = "1",
            fillRule = "BEFORE", fillChar = "30"
    )
    private String safeControlInfo53;

    /** 54域-附加金额 */
    @ISO8583Annotation(
            fldIndex = 54, dataFldLength = 256, encodeRule = "ASCII", fldFlag = "3"
    )
    private String additionalAmt54;

    /** 55域-IC卡数据域 */
    @ISO8583Annotation(
            fldIndex = 55, dataFldLength = 512, encodeRule = "ASCII", fldFlag = "3"
    )
    private String ICCardDataDomain55;

    /** 57域-自定义域 */
    @ISO8583Annotation(
            fldIndex = 57, dataFldLength = 999, encodeRule = "ASCII", fldFlag = "3"
    )
    private String fld57Domain57;

    /** 58域-PBOC电子钱包/存折标准的交易信息 */
    @ISO8583Annotation(
            fldIndex = 58, dataFldLength = 512, encodeRule = "BINARY", fldFlag = "3"
    )
    private String eWalletTransInfo58;

    /** 60域-自定义域 */
    @ISO8583Annotation(
            fldIndex = 60, dataFldLength = 17, encodeRule = "BCD", fldFlag = "3"
    )
    private String fld60Domain60;

    /** 61域-原始信息域 */
    @ISO8583Annotation(
            fldIndex = 61, dataFldLength = 29, encodeRule = "BCD", fldFlag = "3"
    )
    private String originalInfoDomain61;

    /** 62域-自定义域 */
    @ISO8583Annotation(
            fldIndex = 62, dataFldLength = 999, encodeRule = "BINARY", fldFlag = "3"
    )
    private String fld62Domain62;

    /** 63域-自定义域 */
    @ISO8583Annotation(
            fldIndex = 63, dataFldLength = 512, encodeRule = "ASCII", fldFlag = "3"
    )
    private String fld63Domain63;

    /** 64域-MAC */
    @ISO8583Annotation(
            fldIndex = 64, dataFldLength = 8, encodeRule = "ASCII", fldFlag = "1",
            fillRule = "BEFORE", fillChar = "20", defalutValue = "0000000000000000"
    )
    private String mac64;
}