package com.jaemon.commons.toolkit.enums;

import com.jaemon.commons.toolkit.IPairs;

/**
 * ExceptionEnum
 *
 * @author Jaemon
 */
public enum ExceptionEnum implements IPairs<String, String, ExceptionEnum> {

    ISO8583_ANALYZER_EXCEPTION("ISO8583_ANALYZER", "ISO8583解析异常"),
    DEEP_COPY_EXCEPTION("DEEP_COPY", "深拷贝异常"),
    QRCODE_EXCEPTION("QRCODE", "二维码操作异常"),
    PDF_OPT_EXCEPTION("PDF_OPT", "pdf操作操作异常"),
    BASE64_OPT_EXCEPTION("BASE64_OPT", "Base64操作操作异常"),
    NUMBER_STRING_EXCEPTION("NUMBER_STRING", "NUMBER_STRING操作操作异常")
    ;


    /**
     * 错误码
     * */
    private String errorCode;

    /**
     * 错误描述
     * */
    private String errorDesc;


    ExceptionEnum(String errorCode, String errorDesc) {
        this.errorCode = errorCode;
        this.errorDesc = errorDesc;
    }


    @Override
    public ExceptionEnum get() {
        return this;
    }

    @Override
    public String key() {
        return errorCode;
    }

    @Override
    public String value() {
        return errorDesc;
    }
}