package com.jaemon.commons.toolkit;

import com.jaemon.commons.toolkit.exception.Base64Exception;
import org.apache.commons.io.FileUtils;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

import java.io.File;
import java.io.IOException;
import java.util.Base64;

/**
 * Base64 和文件互转工具类
 *
 * @author Jaemon
 */
public class Base64Utils {
    private Base64Utils() {
    }

    /**
     * 文件转 Base64 编码
     *
     * @param srcFile 待编码文件
     * @return result
     */
    public static String encoder(File srcFile) {
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(file2Bytes(srcFile));
    }

    /**
     * 还原 base64 解码为文件
     *
     * @param base64Code 待解码 Base64 字符串
     * @param descFile 解码的文件路径
     */
    public static void decoder(String base64Code, File descFile) {
        BASE64Decoder decoder = new BASE64Decoder();
        try {
            byte[] bytes = decoder.decodeBuffer(base64Code);
            bytes2File(bytes, descFile);
        } catch (IOException e) {
            throw new Base64Exception(e);
        }
    }


    public static String jdk8Encoder(File srcFile) {
        return Base64.getEncoder().encodeToString(file2Bytes(srcFile));
    }

    public static String jdk8MimeEncoder(File srcFile) {
        return Base64.getMimeEncoder().encodeToString(file2Bytes(srcFile));
    }

    public static String jdk8UrlEncoder(File srcFile) {
        return Base64.getUrlEncoder().encodeToString(file2Bytes(srcFile));
    }


    public static void jdk8Decoder(String base64Code, File descFile) {
        byte[] bytes = Base64.getDecoder().decode(base64Code);
        bytes2File(bytes, descFile);
    }

    public static void jdk8MimeDecoder(String base64Code, File descFile) {
        byte[] bytes = Base64.getMimeDecoder().decode(base64Code);
        bytes2File(bytes, descFile);
    }

    public static void j8UrlDecoder(String base64Code, File descFile) {
        byte[] bytes = Base64.getUrlDecoder().decode(base64Code);
        bytes2File(bytes, descFile);
    }

    private static byte[] file2Bytes(File srcFile) {
        byte[] bytes;
        try {
            bytes = FileUtils.readFileToByteArray(srcFile);
        } catch (IOException e) {
            throw new Base64Exception(e);
        }
        return bytes;
    }

    private static void bytes2File(byte[] bytes, File descFile) {
        try {
            FileUtils.writeByteArrayToFile(descFile, bytes);
        } catch (IOException e) {
            throw new Base64Exception(e);
        }
    }
}