/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.dubbo.filter;

import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.boot.dubbo.bo.InterfaceInfo;

public abstract class AbstractStatisticsFilter
implements Filter {
    public static final Map<InterfaceInfo, Map<String, AtomicLong>> INTERFACE_STATISTICS = new ConcurrentHashMap<InterfaceInfo, Map<String, AtomicLong>>();
    private static final long ZERO = 0L;

    public abstract Invoker<?> getInvoker(Invoker<?> var1, Invocation var2);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        AbstractStatisticsFilter.incrementAndGet(this.buildInterfaceInfo(this.getInvoker(invoker, invocation)), invocation.getMethodName());
        return invoker.invoke(invocation);
    }

    public static long get(InterfaceInfo info, String methodName) {
        if (!INTERFACE_STATISTICS.containsKey(info)) {
            return 0L;
        }
        AtomicLong ct = INTERFACE_STATISTICS.get(info).get(methodName);
        return ct == null ? 0L : ct.get();
    }

    private InterfaceInfo buildInterfaceInfo(Invoker<?> invoker) {
        return new InterfaceInfo(invoker);
    }

    private static synchronized void incrementAndGet(InterfaceInfo info, String methodName) {
        AtomicLong ct;
        if (!INTERFACE_STATISTICS.containsKey(info)) {
            INTERFACE_STATISTICS.put(info, new ConcurrentHashMap(16));
        }
        if ((ct = INTERFACE_STATISTICS.get(info).get(methodName)) == null) {
            ct = new AtomicLong(0L);
            INTERFACE_STATISTICS.get(info).put(methodName, ct);
        }
        ct.incrementAndGet();
    }
}

