/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.dubbo.common;

import com.alibaba.dubbo.common.json.JSON;
import com.alibaba.dubbo.common.json.JSONArray;
import com.alibaba.dubbo.common.json.JSONObject;
import com.alibaba.dubbo.common.json.ParseException;
import com.alibaba.dubbo.common.utils.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class SubUtil {
    private static final String DEFAULT_SUFFIX = "......content truncated! real length is";

    public static void subJsonArray(JSONArray jsonArray) {
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObj = jsonArray.getObject(i);
                SubUtil.subJson(jsonObj);
            }
        }
    }

    public static Object[] subJsonArrayWithArray(String json) throws ParseException {
        Object[] objectArray;
        Object obj = JSON.parse((String)json);
        if (obj instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)obj;
            Object[] objects = new Object[jsonArray.length()];
            for (int i = 0; i < jsonArray.length(); ++i) {
                Object valueObj = jsonArray.get(i);
                objects[i] = valueObj instanceof JSONObject ? SubUtil.subJsonWithMap((JSONObject)valueObj) : (valueObj instanceof JSONArray ? SubUtil.subJsonArrayWithList((JSONArray)valueObj) : valueObj);
            }
            return objects;
        }
        if (obj instanceof JSONObject) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = SubUtil.subJsonWithMap((JSONObject)obj);
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = obj;
        }
        return objectArray;
    }

    public static Object subJsonWithObject(String json) throws ParseException {
        Object obj = JSON.parse((String)json);
        if (obj instanceof JSONObject) {
            return SubUtil.subJsonWithMap((JSONObject)obj);
        }
        return obj instanceof JSONArray ? SubUtil.subJsonArrayWithList((JSONArray)obj) : Collections.emptyMap();
    }

    public static List<Object> subJsonArrayWithList(JSONArray jsonArray) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        if (jsonArray != null && jsonArray.length() > 0) {
            Object obj = jsonArray.get(0);
            if (obj instanceof JSONObject) {
                resultList.add(SubUtil.subJsonWithMap((JSONObject)obj));
            } else if (obj instanceof JSONArray) {
                resultList.add(SubUtil.subJsonArrayWithList((JSONArray)obj));
            } else {
                resultList.add(obj);
            }
            if (jsonArray.length() > 1) {
                resultList.add("*** content truncated! array.length = " + jsonArray.length() + " ***");
            }
        }
        return resultList;
    }

    public static Map<String, Object> subJsonWithMap(JSONObject jsonObject) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(0);
        if (jsonObject != null) {
            Iterator jsonKeys = jsonObject.keys();
            while (jsonKeys.hasNext()) {
                String jsonKey = (String)jsonKeys.next();
                Object valueObj = jsonObject.get(jsonKey);
                if (valueObj instanceof JSONObject) {
                    Map<String, Object> subMap = SubUtil.subJsonWithMap((JSONObject)valueObj);
                    resultMap.put(jsonKey, subMap);
                    continue;
                }
                if (valueObj instanceof JSONArray) {
                    JSONArray propArrary = (JSONArray)valueObj;
                    resultMap.put(jsonKey, SubUtil.subJsonArrayWithList(propArrary));
                    continue;
                }
                resultMap.put(jsonKey, valueObj);
            }
        }
        return resultMap;
    }

    public static void subJson(JSONObject jsonObject) {
        if (jsonObject != null) {
            Iterator jsonKeys = jsonObject.keys();
            while (jsonKeys.hasNext()) {
                String jsonKey = (String)jsonKeys.next();
                JSONArray propArray = jsonObject.getArray(jsonKey);
                String propStr = jsonObject.getString(jsonKey);
                JSONObject propObject = jsonObject.getObject(jsonKey);
                if (StringUtils.isNotEmpty((String)propStr) && propStr.length() > 512) {
                    jsonObject.put(jsonKey, (Object)SubUtil.subStr(propStr, 512));
                }
                if (propObject != null) {
                    SubUtil.subJson(propObject);
                }
                if (propArray == null || propArray.length() <= 1) continue;
                JSONArray newPropArr = new JSONArray();
                newPropArr.add(propArray.get(0));
                newPropArr.add((Object)("*** content truncated! array.length = " + propArray.length() + " ***"));
                jsonObject.put(jsonKey, (Object)newPropArr);
            }
        }
    }

    public static JSONArray subJsonArray(String json) throws ParseException {
        Object obj = JSON.parse((String)json);
        if (obj instanceof JSONArray) {
            JSONArray jsonArr = (JSONArray)obj;
            SubUtil.subJsonArray(jsonArr);
            return jsonArr;
        }
        return null;
    }

    public static JSONObject subJsonObject(String json) throws ParseException {
        Object obj = JSON.parse((String)json);
        if (obj instanceof JSONObject) {
            JSONObject jsonObj = (JSONObject)obj;
            SubUtil.subJson(jsonObj);
            return jsonObj;
        }
        return null;
    }

    public static String subJson(String json) throws IOException, ParseException {
        Object obj = JSON.parse((String)json);
        String result = json;
        if (obj instanceof JSONObject) {
            JSONObject jsonObj = (JSONObject)obj;
            SubUtil.subJson(jsonObj);
            result = JSON.json((Object)jsonObj);
        } else if (obj instanceof JSONArray) {
            JSONArray jsonArr = (JSONArray)obj;
            SubUtil.subJsonArray(jsonArr);
            result = JSON.json((Object)jsonArr);
        }
        return result;
    }

    public static String subStr(String orginStr, int maxLength) {
        String result = orginStr == null ? "" : orginStr;
        int len = result.length();
        if (len > maxLength) {
            result = result.substring(0, maxLength -= (DEFAULT_SUFFIX + len).length()) + DEFAULT_SUFFIX + len;
        }
        return result;
    }
}

