/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.dubbo.autoconfigure;

import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.rpc.Exporter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.dubbo.annotation.EnableDubbo;
import org.springframework.boot.dubbo.autoconfigure.DubboAnnotaion;
import org.springframework.boot.dubbo.autoconfigure.DubboApplication;
import org.springframework.boot.dubbo.autoconfigure.DubboAutoConfiguration;
import org.springframework.boot.dubbo.autoconfigure.DubboConsumer;
import org.springframework.boot.dubbo.autoconfigure.DubboProtocol;
import org.springframework.boot.dubbo.autoconfigure.DubboProvider;
import org.springframework.boot.dubbo.autoconfigure.DubboRegistry;
import org.springframework.boot.dubbo.bo.RegistryBo;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.annotation.AnnotationScopeMetadataResolver;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ScopeMetadata;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotationMetadata;

@Configuration
@ConditionalOnClass(value={Exporter.class})
@ConditionalOnBean(annotation={EnableDubbo.class})
@AutoConfigureAfter(value={DubboAutoConfiguration.class})
@EnableConfigurationProperties(value={DubboAnnotaion.class, DubboApplication.class, DubboProtocol.class, DubboRegistry.class, DubboProvider.class, DubboConsumer.class})
public class DubboRegistryAutoConfiguration
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(DubboRegistryAutoConfiguration.class);
    private static final String REGISTERS_PREFIX = "registries";
    private ScopeMetadataResolver scopeMetadataResolver = new AnnotationScopeMetadataResolver();
    private BeanNameGenerator beanNameGenerator = new AnnotationBeanNameGenerator();
    private DubboRegistry dubboRegistry;

    public void setEnvironment(Environment environment) {
        this.initDubboRegistry(environment);
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry beanDefinitionRegistry) {
        this.registerDubboRegistries(beanDefinitionRegistry);
    }

    private void registerDubboRegistries(BeanDefinitionRegistry beanDefinitionRegistry) {
        String protocol = this.dubboRegistry.getProtocol();
        boolean isRegister = this.dubboRegistry.isRegister();
        boolean isSubscribe = this.dubboRegistry.isSubscribe();
        if (this.dubboRegistry.getRegistries() == null || this.dubboRegistry.getRegistries().isEmpty()) {
            throw new IllegalArgumentException("registry config is empty!");
        }
        int isDefault = 1;
        int[] count = new int[]{0};
        this.dubboRegistry.getRegistries().stream().forEach(registryBo -> {
            count[0] = count[0] + 1;
            AnnotatedGenericBeanDefinition abd = new AnnotatedGenericBeanDefinition(RegistryConfig.class);
            if (registryBo.getProtocol() == null || registryBo.getProtocol().isEmpty()) {
                registryBo.setProtocol(protocol);
            }
            MutablePropertyValues mpv = abd.getPropertyValues();
            mpv.add("address", (Object)registryBo.getAddress());
            mpv.add("group", (Object)registryBo.getGroup());
            mpv.add("protocol", (Object)registryBo.getProtocol());
            mpv.add("check", (Object)registryBo.isCheck());
            mpv.add("subscribe", (Object)isSubscribe);
            mpv.add("register", (Object)isRegister);
            if (this.dubboRegistry.getFile() != null && !this.dubboRegistry.getFile().isEmpty()) {
                mpv.add("file", (Object)(this.dubboRegistry.getFile() + "/" + registryBo.getName()));
            }
            if (isDefault == count[0]) {
                mpv.add("default", (Object)true);
            }
            this.registerBean(beanDefinitionRegistry, registryBo.getName(), abd);
        });
    }

    private void registerBean(BeanDefinitionRegistry registry, String name, AnnotatedGenericBeanDefinition abd) {
        ScopeMetadata scopeMetadata = this.scopeMetadataResolver.resolveScopeMetadata((BeanDefinition)abd);
        abd.setScope(scopeMetadata.getScopeName());
        String beanName = name != null ? name : this.beanNameGenerator.generateBeanName((BeanDefinition)abd, registry);
        AnnotationConfigUtils.processCommonDefinitionAnnotations((AnnotatedBeanDefinition)abd);
        BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder((BeanDefinition)abd, beanName);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)definitionHolder, (BeanDefinitionRegistry)registry);
        log.info("register bean : {} - {}", (Object)beanName, (Object)abd.getBeanClassName());
    }

    private void initDubboRegistry(Environment environment) {
        String temp;
        DubboRegistry def = new DubboRegistry();
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)environment, "dubbo.registry.");
        Map maps = propertyResolver.getSubProperties("");
        String protocol = def.getProtocol();
        boolean register = def.isRegister();
        boolean subscribe = def.isSubscribe();
        String file = def.getFile();
        if (maps.containsKey("file") && (temp = (String)propertyResolver.getProperty("file", String.class)) != null && !temp.isEmpty()) {
            file = temp;
        }
        if (maps.containsKey("protocol") && (temp = (String)propertyResolver.getProperty("protocol", String.class)) != null && !temp.isEmpty()) {
            protocol = temp;
        }
        if (maps.containsKey("register") && (temp = (String)propertyResolver.getProperty("register", String.class)) != null && !temp.isEmpty()) {
            register = Boolean.parseBoolean(temp);
        }
        if (maps.containsKey("subscribe") && (temp = (String)propertyResolver.getProperty("subscribe", String.class)) != null && !temp.isEmpty()) {
            subscribe = Boolean.parseBoolean(temp);
        }
        if ((maps = propertyResolver.getSubProperties(REGISTERS_PREFIX)).isEmpty()) {
            throw new RuntimeException("registry config is empty!  dubbo.registry.registries[i]");
        }
        this.setDubboRegistry(protocol, register, subscribe, file, this.builderRegistryBos(maps, propertyResolver));
    }

    private List<RegistryBo> builderRegistryBos(Map<String, Object> maps, RelaxedPropertyResolver propertyResolver) {
        List nodes = maps.keySet().stream().map(e -> e.substring(0, 3)).distinct().collect(Collectors.toList());
        int nodeSize = nodes.size();
        ArrayList<RegistryBo> registryBos = new ArrayList<RegistryBo>(nodeSize);
        nodes.stream().forEach(k -> {
            String name = (String)propertyResolver.getProperty(REGISTERS_PREFIX + k + ".name", String.class);
            String address = (String)propertyResolver.getProperty(REGISTERS_PREFIX + k + ".address", String.class);
            String group = (String)propertyResolver.getProperty(REGISTERS_PREFIX + k + ".group", String.class);
            String nodeProtocol = (String)propertyResolver.getProperty(REGISTERS_PREFIX + k + ".protocol", String.class);
            RegistryBo bo = new RegistryBo();
            if (name != null && !name.isEmpty()) {
                bo.setName(name);
            }
            if (address != null && !address.isEmpty()) {
                bo.setAddress(address);
            }
            if (group != null && !group.isEmpty()) {
                bo.setGroup(group);
            }
            if (nodeProtocol != null && !nodeProtocol.isEmpty()) {
                bo.setProtocol(nodeProtocol);
            }
            registryBos.add(bo);
        });
        return registryBos;
    }

    private void setDubboRegistry(String protocol, boolean register, boolean subscribe, String file, List<RegistryBo> registryBos) {
        this.dubboRegistry = new DubboRegistry();
        this.dubboRegistry.setProtocol(protocol);
        this.dubboRegistry.setRegister(register);
        this.dubboRegistry.setSubscribe(subscribe);
        this.dubboRegistry.setFile(file);
        this.dubboRegistry.setRegistries(registryBos);
    }
}

