/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.dubbo.autoconfigure;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.ProviderConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.rpc.Exporter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.dubbo.annotation.EnableDubbo;
import org.springframework.boot.dubbo.autoconfigure.DubboAnnotaion;
import org.springframework.boot.dubbo.autoconfigure.DubboApplication;
import org.springframework.boot.dubbo.autoconfigure.DubboAutoConfiguration;
import org.springframework.boot.dubbo.autoconfigure.DubboConsumer;
import org.springframework.boot.dubbo.autoconfigure.DubboProtocol;
import org.springframework.boot.dubbo.autoconfigure.DubboProvider;
import org.springframework.boot.dubbo.autoconfigure.DubboRegistry;
import org.springframework.boot.dubbo.autoconfigure.DubboRegistryAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Exporter.class})
@ConditionalOnBean(annotation={EnableDubbo.class})
@AutoConfigureAfter(value={DubboAutoConfiguration.class, DubboRegistryAutoConfiguration.class})
@EnableConfigurationProperties(value={DubboAnnotaion.class, DubboApplication.class, DubboProtocol.class, DubboRegistry.class, DubboProvider.class, DubboConsumer.class})
public class DubboProviderAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DubboProviderAutoConfiguration.class);
    @Autowired
    private DubboProvider dubboProvider;
    @Autowired
    private ApplicationConfig applicationConfig;
    @Autowired
    private ProtocolConfig protocolConfig;
    @Autowired
    private List<RegistryConfig> registries;

    @Bean
    public ProviderConfig providerConfig() {
        log.info("ProviderConfig:{}", (Object)this.dubboProvider);
        ProviderConfig providerConfig = new ProviderConfig();
        providerConfig.setTimeout(Integer.valueOf(this.dubboProvider.getTimeout()));
        providerConfig.setRetries(Integer.valueOf(this.dubboProvider.getRetries()));
        providerConfig.setFilter(this.dubboProvider.getFilter());
        providerConfig.setDelay(Integer.valueOf(this.dubboProvider.getDelay()));
        providerConfig.setValidation(this.dubboProvider.getValidation().toString());
        providerConfig.setPayload(Integer.valueOf(this.dubboProvider.getPayload()));
        providerConfig.setApplication(this.applicationConfig);
        providerConfig.setRegistries(this.registries);
        providerConfig.setProtocol(this.protocolConfig);
        return providerConfig;
    }
}

