/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.dubbo.autoconfigure;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.spring.AnnotationBean;
import com.alibaba.dubbo.rpc.Exporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.dubbo.annotation.EnableDubbo;
import org.springframework.boot.dubbo.autoconfigure.DubboAnnotaion;
import org.springframework.boot.dubbo.autoconfigure.DubboApplication;
import org.springframework.boot.dubbo.autoconfigure.DubboConsumer;
import org.springframework.boot.dubbo.autoconfigure.DubboProtocol;
import org.springframework.boot.dubbo.autoconfigure.DubboProvider;
import org.springframework.boot.dubbo.autoconfigure.DubboRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Exporter.class})
@ConditionalOnBean(annotation={EnableDubbo.class})
@EnableConfigurationProperties(value={DubboAnnotaion.class, DubboApplication.class, DubboProtocol.class, DubboRegistry.class, DubboProvider.class, DubboConsumer.class})
public class DubboAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DubboAutoConfiguration.class);
    @Autowired
    private DubboApplication dubboApplication;
    @Autowired
    private DubboProtocol dubboProtocol;

    @Bean
    public static AnnotationBean annotationBean(@Value(value="${dubbo.annotation.package-name}") String packageName) {
        if (StringUtils.isBlank((String)packageName)) {
            throw new IllegalArgumentException("annotation package is empty!");
        }
        AnnotationBean annotationBean = new AnnotationBean();
        annotationBean.setPackage(packageName);
        return annotationBean;
    }

    @Bean
    public ApplicationConfig applicationConfig() {
        if (StringUtils.isBlank((String)this.dubboApplication.getName())) {
            throw new IllegalArgumentException("application name is empty");
        }
        ApplicationConfig applicationConfig = new ApplicationConfig();
        applicationConfig.setOwner(this.dubboApplication.getOwner());
        applicationConfig.setVersion(this.dubboApplication.getVersion());
        applicationConfig.setName(this.dubboApplication.getName());
        applicationConfig.setLogger(this.dubboApplication.getLogger());
        return applicationConfig;
    }

    @Bean
    public ProtocolConfig protocolConfig() {
        ProtocolConfig protocolConfig = new ProtocolConfig();
        protocolConfig.setName(this.dubboProtocol.getName());
        protocolConfig.setPort(Integer.valueOf(this.dubboProtocol.getPort()));
        protocolConfig.setThreads(Integer.valueOf(this.dubboProtocol.getThreads()));
        protocolConfig.setAccesslog(String.valueOf(this.dubboProtocol.isAccessLog()));
        return protocolConfig;
    }
}

