package org.springframework.boot.dubbo.bo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.dubbo.common.DubboConstant;

import java.io.Serializable;

/**
 * 注册中心 具体配置
 *
 * @author   喝咖啡的囊地鼠
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class RegistryBo implements Serializable{


    /**
     * 注册中心名称 * 在 Spring Bean 的名称
     */
    private String name = "default";

    /**
     * 注册根节点组  dubbo
     */
    private String group = "dubbo";


    /**
     * 注册中心地址 127.0.0.1:2181
     */
    private String address = "127.0.0.1:2181";


    /**
     * 接口协议  zookeeper
     */
    private String protocol = DubboConstant.PROTOCOL_ZOOKEEPER;


    /**
     * 注册中心检查
     */
    private boolean check = false;


}
