package org.springframework.boot.dubbo.bo;

import com.alibaba.dubbo.rpc.Invoker;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.dubbo.common.DubboConstant;

import java.io.Serializable;

/**
 * 标注服务接口唯一性
 *
 * @author   喝咖啡的囊地鼠
 *
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
public class InterfaceInfo implements Serializable {
    private Class<?> clazz;
    private String group;
    private String version;
    public InterfaceInfo(Invoker<?> invoker){
        this.clazz = invoker.getInterface();
        this.group = invoker.getUrl().getParameter(DubboConstant.GROUP);
        this.version = invoker.getUrl().getParameter(DubboConstant.VERSION);
    }
}
