package org.springframework.boot.dubbo.autoconfigure;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author 喝咖啡的囊地鼠
 */
@Data
@ConfigurationProperties(prefix = "zipkin.annotation")
public class ZipkinTraceConfig {
    private boolean enabled = true;
    private int connectTimeout;
    private int readTimeout;
    private int flushInterval = 0;
    private boolean compressionEnabled = true;
    private String url;

}
