package org.springframework.boot.dubbo.autoconfigure;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.dubbo.common.DubboConstant;

/**
 * dubbo 消费方配置
 *
 * @author   喝咖啡的囊地鼠
 *
 */
@Data
@ConfigurationProperties(prefix = "dubbo.provider")
public class DubboProvider {
    /**
     * 服务的超时时间,单位毫秒
     */
    private int timeout = 10000;

    /**
     * 调用失败重试次数
     */
    private int retries = 0;

    /**
     * 过滤器
     */
    private String filter = DubboConstant.INTERFACE_LOG_FILTER;

    /**
     * 是否延迟暴露,-1表示不延迟暴露
     */
    private int delay = -1;


    /**
     * 请求及响应数据包大小限制，单位：字节
     */
    private int payload = DubboConstant.PAYLOAD;

    /**
     * 是否校验参数
     */
    private Boolean validation = DubboConstant.VALIDATION;

}
