package org.springframework.boot.dubbo.autoconfigure;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.dubbo.common.DubboConstant;

/**
 * dubbo 协议配置
 *
 * @author   喝咖啡的囊地鼠
 *
 */
@Data
@ConfigurationProperties(prefix = "dubbo.protocol")
public class DubboProtocol {
    /**
     * 接口协议
     */
    private String name = "dubbo";

    /**
     * 暴露服务的端口
     */
    private int port = 20880;

    /**
     * 线程池大小 默认200
     */
    private int threads = 200;

    /**
     * 请求及响应数据包大小限制，单位：字节
     */
    private int payload = DubboConstant.PAYLOAD;

    /**
     * 是否记录接口日志
     */
    private boolean accessLog = true;

}
