package org.springframework.boot.dubbo.autoconfigure;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.dubbo.common.DubboConstant;

/**
 * dubbo 消费方配置
 *
 * @author   喝咖啡的囊地鼠
 *
 */

@Data
@ConfigurationProperties(prefix = "dubbo.consumer")
public class DubboConsumer {

    /**
     * 服务的超时时间,单位毫秒
     */
    private int timeout = 10000;

    /**
     * 调用失败重试次数
     */
    private int retries = 0;

    /**
     * 过滤器
     */
    private String filter = DubboConstant.INTERFACE_LOG_FILTER;

    /**
     * 是否校验参数
     */
    private Boolean validation = DubboConstant.VALIDATION;

    /**
     * 消费端是否娇艳
     */
    private Boolean check = DubboConstant.CHECK;

}
