package org.springframework.boot.dubbo.autoconfigure;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Dubbo 应用配置
 *
 * @author   喝咖啡的囊地鼠
 *
 */

@Data
@ConfigurationProperties(prefix = "dubbo.application")
public class DubboApplication {

    /**
     * 应用名
     */
    private String name = "sample";

    /**
     * 日志输出方式
     */
    private String logger = "slf4j";


    /**
     * 负责人
     */
    private String owner;

    /**
     * 模块版本
     */
    private String version;


}
