package org.springframework.boot.dubbo.annotation;

import org.springframework.boot.dubbo.autoconfigure.DubboAutoConfiguration;
import org.springframework.boot.dubbo.autoconfigure.DubboConsumerAutoConfiguration;
import org.springframework.boot.dubbo.autoconfigure.DubboProviderAutoConfiguration;
import org.springframework.boot.dubbo.autoconfigure.DubboRegistryAutoConfiguration;
import org.springframework.context.annotation.Import;

import java.lang.annotation.*;

/**
 * Enable* 替代 spring.factories
 *
 * @author   喝咖啡的囊地鼠
 *
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Import({
        DubboAutoConfiguration.class,
        DubboRegistryAutoConfiguration.class,
        DubboProviderAutoConfiguration.class,
        DubboConsumerAutoConfiguration.class})
public @interface EnableDubbo {
}
