/*
 * Decompiled with CFR 0.152.
 */
package cn.net.shoplus.util;

import cn.net.shoplus.util.Base64Util;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AESUtil {
    private static final String UTF8 = "UTF-8";
    private static final String ALGORITHM = "AES";
    private static final String ALGORITHM_CIPHER = "AES/ECB/PKCS5Padding";

    public static SecretKey getSecretKey(String password) {
        byte[] passwordData = password.getBytes();
        if (passwordData.length > 16) {
            throw new IllegalArgumentException("password \u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e16");
        }
        byte[] keyData = new byte[16];
        System.arraycopy(passwordData, 0, keyData, 0, passwordData.length);
        return new SecretKeySpec(keyData, ALGORITHM);
    }

    public static byte[] encrypt(byte[] data, String password) throws Exception {
        SecretKey secretKey = AESUtil.getSecretKey(password);
        Cipher cipher = Cipher.getInstance(ALGORITHM_CIPHER);
        cipher.init(1, secretKey);
        return cipher.doFinal(data);
    }

    public static byte[] decrypt(byte[] data, String password) throws Exception {
        SecretKey secretKey = AESUtil.getSecretKey(password);
        Cipher cipher = Cipher.getInstance(ALGORITHM_CIPHER);
        cipher.init(2, secretKey);
        return cipher.doFinal(data);
    }

    public static String encryptToBase64String(String content, String password) throws Exception {
        byte[] data = content.getBytes(UTF8);
        byte[] result = AESUtil.encrypt(data, password);
        return Base64Util.encodeBase64String(result);
    }

    public static String decryptFromBase64String(String base64String, String password) throws Exception {
        byte[] data = Base64Util.decodeBase64(base64String);
        byte[] contentData = AESUtil.decrypt(data, password);
        return new String(contentData, UTF8);
    }
}

