/*
 * Decompiled with CFR 0.152.
 */
package cn.net.shoplus.request;

import cn.net.shoplus.common.RequestForm;
import cn.net.shoplus.common.RequestMethod;
import cn.net.shoplus.common.SdkConfig;
import cn.net.shoplus.common.UploadFile;
import cn.net.shoplus.response.BaseResponse;
import cn.net.shoplus.util.ClassUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class BaseRequest<T extends BaseResponse<?>> {
    private static String FORMAT_TYPE = SdkConfig.FORMAT_TYPE;
    private static String TIMESTAMP_PATTERN = SdkConfig.TIMESTAMP_PATTERN;
    private static final String DEFAULT_ACCESS_TOKEN = "";
    private String name;
    private String version;
    private Object data;
    private String timestamp = new SimpleDateFormat(TIMESTAMP_PATTERN).format(new Date());
    private String access_token = "";
    private String format = FORMAT_TYPE;
    @JSONField(serialize=false)
    private List<UploadFile> files;
    @JSONField(serialize=false)
    private RequestMethod requestMethod = RequestMethod.POST;
    @JSONField(serialize=false)
    private Class<T> responseClass;

    @JSONField(serialize=false)
    public abstract String name();

    public BaseRequest() {
        this.name = this.name();
        this.version = this.version();
        this.responseClass = ClassUtil.getSuperClassGenricType(this.getClass(), 0);
    }

    @JSONField(serialize=false)
    protected String version() {
        return SdkConfig.DEFAULT_VERSION;
    }

    public RequestForm createRequestForm() {
        String json = JSON.toJSONString((Object)this);
        JSONObject map = JSON.parseObject((String)json);
        RequestForm requestForm = new RequestForm((Map<? extends String, ?>)map);
        requestForm.setFiles(this.files);
        return requestForm;
    }

    public void setParam(Object param) {
        this.setData(param);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String getAccess_token() {
        return this.access_token;
    }

    public void setAccess_token(String access_token) {
        this.access_token = access_token;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(RequestMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public Class<T> getResponseClass() {
        return this.responseClass;
    }

    public List<UploadFile> getFiles() {
        return this.files;
    }

    public void setFiles(List<UploadFile> files) {
        this.files = files;
    }
}

