/*
 * Decompiled with CFR 0.152.
 */
package cn.net.shoplus.client;

import cn.net.shoplus.common.OpenConfig;
import cn.net.shoplus.common.UploadFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OpenHttp {
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private Map<String, List<Cookie>> cookieStore = new HashMap<String, List<Cookie>>();
    private OkHttpClient httpClient;
    private OpenConfig openConfig;

    public OpenHttp(OpenConfig openConfig) {
        this.openConfig = openConfig;
        this.initHttpClient(openConfig);
    }

    protected void initHttpClient(OpenConfig openConfig) {
        this.httpClient = new OkHttpClient.Builder().connectTimeout((long)openConfig.getConnectTimeoutSeconds(), TimeUnit.SECONDS).readTimeout((long)openConfig.getReadTimeoutSeconds(), TimeUnit.SECONDS).cookieJar(new CookieJar(){

            public void saveFromResponse(HttpUrl httpUrl, List<Cookie> list) {
                OpenHttp.this.cookieStore.put(httpUrl.host(), list);
            }

            public List<Cookie> loadForRequest(HttpUrl httpUrl) {
                List cookies = (List)OpenHttp.this.cookieStore.get(httpUrl.host());
                return cookies != null ? cookies : new ArrayList();
            }
        }).build();
    }

    public String get(String url, Map<String, String> header) throws IOException {
        Request.Builder builder = new Request.Builder().url(url).get();
        this.addHeader(builder, header);
        Request request = builder.build();
        Response response = this.httpClient.newCall(request).execute();
        return response.body().string();
    }

    public String postJsonBody(String url, String json, Map<String, String> header) throws IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request.Builder builder = new Request.Builder().url(url).post(body);
        this.addHeader(builder, header);
        Request request = builder.build();
        Response response = this.httpClient.newCall(request).execute();
        return response.body().string();
    }

    public String postFile(String url, Map<String, Object> form, Map<String, String> header, List<UploadFile> files) throws IOException {
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
        bodyBuilder.setType(MultipartBody.FORM);
        for (UploadFile uploadFile : files) {
            bodyBuilder.addFormDataPart(uploadFile.getName(), uploadFile.getFileName(), RequestBody.create(null, (byte[])uploadFile.getFileData()));
        }
        Set<Map.Entry<String, Object>> entrySet = form.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            bodyBuilder.addFormDataPart(entry.getKey(), String.valueOf(entry.getValue()));
        }
        MultipartBody multipartBody = bodyBuilder.build();
        Request.Builder builder = new Request.Builder().url(url).post((RequestBody)multipartBody);
        this.addHeader(builder, header);
        Request request = builder.build();
        Response response = this.httpClient.newCall(request).execute();
        return response.body().string();
    }

    private void addHeader(Request.Builder builder, Map<String, String> header) {
        if (header != null) {
            Set<Map.Entry<String, String>> entrySet = header.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                builder.addHeader(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
    }

    public void setCookieStore(Map<String, List<Cookie>> cookieStore) {
        this.cookieStore = cookieStore;
    }

    public void setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setOpenConfig(OpenConfig openConfig) {
        this.openConfig = openConfig;
    }
}

