/*
 * Decompiled with CFR 0.152.
 */
package cn.net.shoplus.client;

import cn.net.shoplus.client.OpenRequest;
import cn.net.shoplus.common.OpenConfig;
import cn.net.shoplus.common.RequestForm;
import cn.net.shoplus.request.BaseRequest;
import cn.net.shoplus.response.BaseResponse;
import cn.net.shoplus.util.JsonUtil;
import cn.net.shoplus.util.SignUtil;
import cn.net.shoplus.util.StringUtil;
import java.util.HashMap;
import java.util.Map;

public class OpenClient {
    private static final String ACCEPT_LANGUAGE = "Accept-Language";
    private static final String AUTHORIZATION = "Authorization";
    private static final String PREFIX_BEARER = "Bearer ";
    private static final OpenConfig DEFAULT_CONFIG = new OpenConfig();
    private String url;
    private String appKey;
    private String secret;
    private OpenConfig openConfig;
    private OpenRequest openRequest;

    public OpenClient(String url, String appKey, String secret) {
        this(url, appKey, secret, DEFAULT_CONFIG);
    }

    public OpenClient(String url, String appKey, String secret, OpenConfig openConfig) {
        if (openConfig == null) {
            throw new IllegalArgumentException("openConfig\u4e0d\u80fd\u4e3anull");
        }
        this.url = url;
        this.appKey = appKey;
        this.secret = secret;
        this.openConfig = openConfig;
        this.openRequest = new OpenRequest(openConfig);
    }

    public <T extends BaseResponse<?>> T execute(BaseRequest<T> request) {
        return this.execute(request, null);
    }

    public <T extends BaseResponse<?>> T execute(BaseRequest<T> request, String jwt) {
        RequestForm requestForm = request.createRequestForm();
        Map<String, Object> form = requestForm.getForm();
        form.put(this.openConfig.getAppKeyName(), this.appKey);
        Object data = form.get(this.openConfig.getDataName());
        String dataJson = JsonUtil.toJSONString(data);
        dataJson = StringUtil.encodeUrl(dataJson);
        form.put(this.openConfig.getDataName(), dataJson);
        String sign = SignUtil.createSign(form, this.secret);
        form.put(this.openConfig.getSignName(), sign);
        Map<String, String> header = this.buildHeader(jwt);
        String resp = this.doExecute(this.url, requestForm, header);
        return this.parseResponse(resp, request);
    }

    protected String doExecute(String url, RequestForm requestForm, Map<String, String> header) {
        return this.openRequest.request(this.url, requestForm, header);
    }

    protected <T extends BaseResponse<?>> T parseResponse(String resp, BaseRequest<T> request) {
        return (T)((BaseResponse)JsonUtil.parseObject(resp, request.getResponseClass()));
    }

    protected Map<String, String> buildHeader(String jwt) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put(ACCEPT_LANGUAGE, this.openConfig.getLocale());
        if (StringUtil.isNotEmpty(jwt)) {
            header.put(AUTHORIZATION, PREFIX_BEARER + jwt);
        }
        return header;
    }

    public OpenRequest getOpenRequest() {
        return this.openRequest;
    }

    public void setOpenRequest(OpenRequest openRequest) {
        this.openRequest = openRequest;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public OpenConfig getOpenConfig() {
        return this.openConfig;
    }
}

