/*
 * Decompiled with CFR 0.152.
 */
package cn.net.shoplus.client;

import cn.net.shoplus.client.OpenClient;
import cn.net.shoplus.common.HandshakeParam;
import cn.net.shoplus.common.RequestForm;
import cn.net.shoplus.request.BaseRequest;
import cn.net.shoplus.response.BaseResponse;
import cn.net.shoplus.util.AESUtil;
import cn.net.shoplus.util.JsonUtil;
import cn.net.shoplus.util.MD5Util;
import cn.net.shoplus.util.RSAUtil;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;

public class EncryptClient
extends OpenClient {
    private int holdSessionDelaySeconds = 600;
    private int holdSessionPeriodSeconds = 600;
    private Timer timer;
    private String publicKey;
    private volatile String randomKey;
    private String handshakeUrl;

    private EncryptClient(String url, String appKey, String secret) {
        super(url, appKey, secret);
    }

    public EncryptClient(String url, String appKey, String secret, String publicKey) {
        this(url + "/ssl2", appKey, secret);
        this.handshakeUrl = url + "/handshake2";
        this.publicKey = publicKey;
        this.handshake();
        this.initTimer();
    }

    protected void initTimer() {
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                EncryptClient.this.handshake();
            }
        }, this.holdSessionDelaySeconds * 1000, (long)(this.holdSessionPeriodSeconds * 1000));
    }

    protected synchronized void handshake() {
        String randomKey = this.createRandomKey();
        try {
            HandshakeParam param = this.createHandShakeParam(randomKey);
            String json = this.getOpenRequest().postJsonBody(this.handshakeUrl, JsonUtil.toJSONString(param));
            this.checkHandshakeResponse(json, randomKey);
            this.randomKey = randomKey;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u63e1\u624b\u5931\u8d25", e);
        }
    }

    protected String createRandomKey() {
        return MD5Util.encrypt16(UUID.randomUUID().toString());
    }

    protected HandshakeParam createHandShakeParam(String randomKey) throws Exception {
        HandshakeParam param = new HandshakeParam();
        String randomKeyEncrypted = RSAUtil.encryptByPublicKey(randomKey, this.publicKey);
        param.setApp_key(this.getAppKey());
        param.setData(randomKeyEncrypted);
        return param;
    }

    protected void checkHandshakeResponse(String resp, String randomKey) throws Exception {
        StringResponse result = JsonUtil.parseObject(resp, StringResponse.class);
        if (!result.isSuccess()) {
            throw new RuntimeException(result.getMsg());
        }
        String data = (String)result.getData();
        String desStr = RSAUtil.decryptByPublicKey(data, this.publicKey);
        String content = AESUtil.decryptFromBase64String(desStr, randomKey);
        boolean same = MD5Util.encrypt(randomKey).equals(content);
        if (!same) {
            throw new RuntimeException("\u4f20\u8f93\u9519\u8bef");
        }
    }

    @Override
    protected synchronized String doExecute(String url, RequestForm requestForm, Map<String, String> header) {
        Map<String, Object> form = requestForm.getForm();
        this.encryptData(form);
        this.encryptHeader(header);
        return super.doExecute(url, requestForm, header);
    }

    @Override
    protected <T extends BaseResponse<?>> T parseResponse(String resp, BaseRequest<T> request) {
        try {
            resp = AESUtil.decryptFromBase64String(resp, this.randomKey);
            return super.parseResponse(resp, request);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("AES\u89e3\u5bc6\u5931\u8d25");
        }
    }

    private void encryptData(Map<String, Object> form) {
        String requestDataName = this.getOpenConfig().getDataName();
        String data = (String)form.get(requestDataName);
        try {
            data = AESUtil.encryptToBase64String(data, this.randomKey);
            form.put(requestDataName, data);
        }
        catch (Exception e) {
            throw new RuntimeException("AES\u52a0\u5bc6\u5931\u8d25");
        }
    }

    private void encryptHeader(Map<String, String> header) {
        Set<Map.Entry<String, String>> entrySet = header.entrySet();
        try {
            for (Map.Entry<String, String> entry : entrySet) {
                String key = entry.getKey();
                String value = entry.getValue();
                value = AESUtil.encryptToBase64String(value, this.randomKey);
                header.put(key, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("AES\u52a0\u5bc6head\u5931\u8d25");
        }
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public void setHandshakeUrl(String handshakeUrl) {
        this.handshakeUrl = handshakeUrl;
    }

    public void setHoldSessionDelaySeconds(int holdSessionDelaySeconds) {
        this.holdSessionDelaySeconds = holdSessionDelaySeconds;
    }

    public void setHoldSessionPeriodSeconds(int holdSessionPeriodSeconds) {
        this.holdSessionPeriodSeconds = holdSessionPeriodSeconds;
    }

    private static class StringResponse
    extends BaseResponse<String> {
        private StringResponse() {
        }
    }
}

