package dec.service.common.config;

import dec.service.common.constant.CommonConstants;
import dec.service.common.enums.ResponseCode;
import dec.service.common.exception.ServiceInternalException;
import dec.service.common.vo.ResultVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

/**
 * @author dec
 */
@RestControllerAdvice
public class GlobalExceptionHandleConfig {

    private static final Logger logger = LoggerFactory.getLogger(GlobalExceptionHandleConfig.class);

    private static final String SERVICE_INTERNAL_EXCEPTION_INFO = "service internal exception occurred.";
    private static final String OTHER_EXCEPTION_INFO = "other exception occurred.";

    @ExceptionHandler(Exception.class)
    public ResultVO handleGlobalException(Exception exception) {
        if(exception instanceof ServiceInternalException) {
            logger.error(SERVICE_INTERNAL_EXCEPTION_INFO, exception);
        } else {
            logger.error(OTHER_EXCEPTION_INFO, exception);
        }

        ResultVO result = new ResultVO();
        result.setTotal(0L);
        result.setMessage(CommonConstants.RESPONSE_RESULT_ERROR);
        result.setCode(ResponseCode.SERVICE_INTERNAL_ERROR.getCode());

        return result;
    }

}
