/*
 * Decompiled with CFR 0.152.
 */
package dec.service.common.config.feign.encoder;

import dec.service.common.utils.CommonUtils;
import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import feign.form.ContentType;
import feign.form.FormEncoder;
import feign.form.MultipartFormContentProcessor;
import feign.form.multipart.Writer;
import feign.form.spring.SpringManyMultipartFilesWriter;
import feign.form.spring.SpringSingleMultipartFileWriter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.web.multipart.MultipartFile;

public class FeignSpringFormEncoder
extends FormEncoder {
    public FeignSpringFormEncoder() {
        this((Encoder)new Encoder.Default());
    }

    public FeignSpringFormEncoder(Encoder delegate) {
        super(delegate);
        MultipartFormContentProcessor processor = (MultipartFormContentProcessor)this.getContentProcessor(ContentType.MULTIPART);
        processor.addFirstWriter((Writer)new SpringSingleMultipartFileWriter());
        processor.addFirstWriter((Writer)new SpringManyMultipartFilesWriter());
    }

    public void encode(Object object, Type bodyType, RequestTemplate template) throws EncodeException {
        if (bodyType.equals(MultipartFile[].class)) {
            MultipartFile[] files = (MultipartFile[])object;
            HashMap<String, Object> data = new HashMap<String, Object>(files.length, 1.0f);
            for (MultipartFile file : files) {
                data.put(file.getName(), object);
            }
            super.encode(data, MAP_STRING_WILDCARD, template);
        } else if (bodyType.equals(MultipartFile.class)) {
            MultipartFile file = (MultipartFile)object;
            Map<String, Object> data = Collections.singletonMap(file.getName(), object);
            super.encode(data, MAP_STRING_WILDCARD, template);
        } else if (this.isMultipartFileCollection(object)) {
            Collection collection = (Collection)object;
            HashMap<String, MultipartFile[]> data = new HashMap<String, MultipartFile[]>();
            if (CommonUtils.isNotEmpty(collection)) {
                MultipartFile[] files = new MultipartFile[collection.size()];
                files = collection.toArray(files);
                data.put(files[0].getName(), files);
            }
            super.encode(data, MAP_STRING_WILDCARD, template);
        } else {
            super.encode(object, bodyType, template);
        }
    }

    private boolean isMultipartFileCollection(Object object) {
        if (!(object instanceof Iterable)) {
            return false;
        }
        Iterable iterable = (Iterable)object;
        Iterator iterator = iterable.iterator();
        return iterator.hasNext() && iterator.next() instanceof MultipartFile;
    }
}

