/*
 * Decompiled with CFR 0.152.
 */
package dec.service.common.config.feign.encoder;

import dec.service.common.config.feign.encoder.FeignSpringFormEncoder;
import feign.Request;
import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.protobuf.ProtobufHttpMessageConverter;
import org.springframework.web.multipart.MultipartFile;

public class FeignSpringEncoder
implements Encoder {
    private static final Log log = LogFactory.getLog(SpringEncoder.class);
    private final FeignSpringFormEncoder springFormEncoder = new FeignSpringFormEncoder();
    private ObjectFactory<HttpMessageConverters> messageConverters;

    public FeignSpringEncoder(ObjectFactory<HttpMessageConverters> messageConverters) {
        this.messageConverters = messageConverters;
    }

    public void encode(Object requestBody, Type bodyType, RequestTemplate request) throws EncodeException {
        if (requestBody != null) {
            Object message;
            Class<?> requestType = requestBody.getClass();
            Collection contentTypes = (Collection)request.headers().get("Content-Type");
            MediaType requestContentType = null;
            if (contentTypes != null && !contentTypes.isEmpty()) {
                String type = (String)contentTypes.iterator().next();
                requestContentType = MediaType.valueOf((String)type);
            }
            if (bodyType != null && bodyType.equals(MultipartFile.class) || FeignSpringEncoder.isMultipartFileCollection(requestBody)) {
                if (Objects.equals(requestContentType, MediaType.MULTIPART_FORM_DATA)) {
                    this.springFormEncoder.encode(requestBody, bodyType, request);
                    return;
                }
                message = "Content-Type \"" + MediaType.MULTIPART_FORM_DATA + "\" not set for request body of type " + requestBody.getClass().getSimpleName();
                throw new EncodeException((String)message);
            }
            for (HttpMessageConverter messageConverter : ((HttpMessageConverters)this.messageConverters.getObject()).getConverters()) {
                if (!messageConverter.canWrite(requestType, requestContentType)) continue;
                if (log.isDebugEnabled()) {
                    if (requestContentType != null) {
                        log.debug((Object)("Writing [" + requestBody + "] as \"" + requestContentType + "\" using [" + messageConverter + "]"));
                    } else {
                        log.debug((Object)("Writing [" + requestBody + "] using [" + messageConverter + "]"));
                    }
                }
                FeignOutputMessage outputMessage = new FeignOutputMessage(request);
                try {
                    HttpMessageConverter copy = messageConverter;
                    copy.write(requestBody, requestContentType, (HttpOutputMessage)outputMessage);
                }
                catch (IOException ex) {
                    throw new EncodeException("Error converting request body", (Throwable)ex);
                }
                request.headers(null);
                request.headers(FeignSpringEncoder.getHeaders(outputMessage.getHeaders()));
                Object charset = messageConverter instanceof ByteArrayHttpMessageConverter ? null : (messageConverter instanceof ProtobufHttpMessageConverter && ProtobufHttpMessageConverter.PROTOBUF.isCompatibleWith(outputMessage.getHeaders().getContentType()) ? null : StandardCharsets.UTF_8);
                request.body(Request.Body.encoded((byte[])outputMessage.getOutputStream().toByteArray(), (Charset)charset));
                return;
            }
            message = "Could not write request: no suitable HttpMessageConverter found for request type [" + requestType.getName() + "]";
            if (requestContentType != null) {
                message = (String)message + " and content type [" + requestContentType + "]";
            }
            throw new EncodeException((String)message);
        }
    }

    static HttpHeaders getHttpHeaders(Map<String, Collection<String>> headers) {
        HttpHeaders httpHeaders = new HttpHeaders();
        for (Map.Entry<String, Collection<String>> entry : headers.entrySet()) {
            httpHeaders.put(entry.getKey(), new ArrayList<String>(entry.getValue()));
        }
        return httpHeaders;
    }

    static Map<String, Collection<String>> getHeaders(HttpHeaders httpHeaders) {
        LinkedHashMap<String, Collection<String>> headers = new LinkedHashMap<String, Collection<String>>();
        for (Map.Entry entry : httpHeaders.entrySet()) {
            headers.put((String)entry.getKey(), (Collection)entry.getValue());
        }
        return headers;
    }

    static boolean isMultipartFileCollection(Object object) {
        if (!(object instanceof Iterable)) {
            return false;
        }
        Iterable iterable = (Iterable)object;
        Iterator iterator = iterable.iterator();
        return iterator.hasNext() && iterator.next() instanceof MultipartFile;
    }

    private final class FeignOutputMessage
    implements HttpOutputMessage {
        private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        private final HttpHeaders httpHeaders;

        private FeignOutputMessage(RequestTemplate request) {
            this.httpHeaders = FeignSpringEncoder.getHttpHeaders(request.headers());
        }

        public OutputStream getBody() throws IOException {
            return this.outputStream;
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public ByteArrayOutputStream getOutputStream() {
            return this.outputStream;
        }
    }
}

