/*
 * Decompiled with CFR 0.152.
 */
package dec.service.common.utils;

import dec.service.common.enums.ResponseCode;
import dec.service.common.vo.ResultVO;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.UUID;
import java.util.regex.Pattern;
import org.springframework.data.mongodb.core.query.Criteria;

public class CommonUtils {
    private static DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof String) {
            return ((String)object).trim().isEmpty();
        }
        return false;
    }

    public static boolean isNotEmpty(Object object) {
        return !CommonUtils.isEmpty(object);
    }

    public static String UUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static boolean isEquals(Object a, Object b) {
        if (a != null && b != null) {
            return a.equals(b);
        }
        return false;
    }

    public static ResultVO resultSuccess(String message) {
        ResultVO result = new ResultVO();
        result.setTotal(0L);
        result.setMessage(message);
        result.setCode(ResponseCode.SERVICE_NORMAL.getCode());
        return result;
    }

    public static ResultVO resultSuccess(String message, Object object) {
        ResultVO result = new ResultVO();
        result.setTotal(0L);
        result.setMessage(message);
        result.setResult(object);
        result.setCode(ResponseCode.SERVICE_NORMAL.getCode());
        return result;
    }

    public static ResultVO resultSuccess(String message, long total, Object object) {
        ResultVO result = new ResultVO();
        result.setTotal(0L);
        result.setMessage(message);
        result.setTotal(total);
        result.setResult(object);
        result.setCode(ResponseCode.SERVICE_NORMAL.getCode());
        return result;
    }

    public static ResultVO resultError(String message) {
        ResultVO result = new ResultVO();
        result.setTotal(0L);
        result.setMessage(message);
        result.setCode(ResponseCode.SERVICE_INTERNAL_ERROR.getCode());
        return result;
    }

    public static ResultVO resultError(String message, String code) {
        ResultVO result = new ResultVO();
        result.setTotal(0L);
        result.setMessage(message);
        result.setCode(code);
        return result;
    }

    public static String generateApplicationVersion(String code) {
        return code + "#" + CommonUtils.UUID();
    }

    public static String formatDateTime(LocalDateTime dateTime) {
        if (null == dateTime) {
            return "";
        }
        return dateTimeFormatter.format(dateTime);
    }

    public static LocalDateTime parseDateTime(String dateTimeString) {
        if (CommonUtils.isEmpty(dateTimeString)) {
            return null;
        }
        return LocalDateTime.parse(dateTimeString, dateTimeFormatter);
    }

    public static String formatDate(LocalDate date) {
        if (null == date) {
            return "";
        }
        return dateFormatter.format(date);
    }

    public static LocalDate parseDate(String dateString) {
        if (CommonUtils.isEmpty(dateString)) {
            return null;
        }
        return LocalDate.parse(dateString, dateFormatter);
    }

    public static Pattern generateSearchPattern(String searchText) {
        return Pattern.compile("^.*" + searchText + ".*$", 2);
    }

    public static Criteria generateAndCriteria(Criteria ... criteria) {
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        for (Criteria criterion : criteria) {
            if (!CommonUtils.isNotEmpty(criterion)) continue;
            list.add(criterion);
        }
        if (list.size() > 0) {
            Criteria[] arr = new Criteria[list.size()];
            return new Criteria().andOperator(list.toArray(arr));
        }
        return new Criteria();
    }

    public static Criteria generateOrCriteria(Criteria ... criteria) {
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        for (Criteria criterion : criteria) {
            if (!CommonUtils.isNotEmpty(criterion)) continue;
            list.add(criterion);
        }
        if (list.size() > 0) {
            Criteria[] arr = new Criteria[list.size()];
            return new Criteria().orOperator(list.toArray(arr));
        }
        return new Criteria();
    }

    public static InetAddress getLocalHostAddress() throws IOException {
        InetAddress candidateAddress = null;
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface iface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
            while (inetAddrs.hasMoreElements()) {
                InetAddress inetAddr = inetAddrs.nextElement();
                if (inetAddr.isLoopbackAddress()) continue;
                if (inetAddr.isSiteLocalAddress()) {
                    return inetAddr;
                }
                if (candidateAddress != null) continue;
                candidateAddress = inetAddr;
            }
        }
        if (CommonUtils.isEmpty(candidateAddress)) {
            candidateAddress = InetAddress.getLocalHost();
        }
        return candidateAddress;
    }
}

