/*
 * Decompiled with CFR 0.152.
 */
package io.ghostwriter.rt.tracer.serializer;

import io.ghostwriter.rt.tracer.serializer.Indentation;
import io.ghostwriter.rt.tracer.serializer.TracerSerializer;

public class StringSerializer
implements TracerSerializer {
    private final Indentation indentation = new Indentation();
    private final boolean doIndent;

    public StringSerializer(boolean doIndent) {
        this.doIndent = doIndent;
    }

    public StringSerializer() {
        this(true);
    }

    @Override
    public String entering(Object source, String method, Object ... params) {
        int DEFAULT_CAPACITY = 255;
        StringBuffer sb = new StringBuffer(255);
        Class<?> contextClass = source instanceof Class ? (Class<?>)source : source.getClass();
        assert (contextClass != null);
        String context = contextClass.getCanonicalName();
        if (this.doIndent) {
            this.indentation.apply(sb);
        }
        sb.append(context).append(".").append(method).append("(");
        this.appendParameters(sb, params).append(") {\n");
        if (this.doIndent) {
            this.indentation.indent();
        }
        return sb.toString();
    }

    @Override
    public String exiting(Object source, String method) {
        int DEFAULT_CAPACITY = 32;
        StringBuffer sb = new StringBuffer(32);
        if (this.doIndent) {
            this.indentation.dedent();
            this.indentation.apply(sb);
        }
        sb.append("}\n");
        return sb.toString();
    }

    @Override
    public String valueChange(Object source, String method, String variable, Object value) {
        int DEFAULT_CAPACITY = 64;
        StringBuffer sb = new StringBuffer(64);
        String strValue = this.serialize(value);
        if (this.doIndent) {
            this.indentation.apply(sb);
        }
        sb.append(variable).append(" = ").append(strValue).append("\n");
        return sb.toString();
    }

    @Override
    public String returning(Object source, String method, Object returnValue) {
        int DEFAULT_CAPACITY = 64;
        StringBuffer sb = new StringBuffer(64);
        String value = this.serialize(returnValue);
        if (this.doIndent) {
            this.indentation.apply(sb);
        }
        sb.append("return ").append(value).append("\n");
        return sb.toString();
    }

    @Override
    public String onError(Object source, String method, Throwable error) {
        int DEFAULT_CAPACITY = 128;
        StringBuffer sb = new StringBuffer(128);
        if (this.doIndent) {
            this.indentation.apply(sb);
        }
        String errorStr = this.serialize(error);
        sb.append("ERROR: ").append(errorStr);
        return sb.toString();
    }

    @Override
    public String timeout(Object source, String method, long timeoutThreshold, long timeout) {
        int DEFAULT_CAPACITY = 64;
        StringBuffer sb = new StringBuffer(64);
        if (this.doIndent) {
            this.indentation.apply(sb);
        }
        sb.append("TIMEOUT: ").append(timeout).append("\n");
        return sb.toString();
    }

    private StringBuffer appendParameters(StringBuffer sb, Object[] params) {
        int NUMBER_OF_ENTRIES_PER_PARAMETERS = 2;
        for (int i = 0; i < params.length; i += 2) {
            boolean isFinalParameter;
            Object parameterName = params[i];
            Object parameterValue = params[i + 1];
            String name = String.valueOf(parameterName);
            String value = this.serialize(parameterValue);
            sb.append(name).append(" = ").append(value);
            boolean bl = isFinalParameter = i == params.length - 2;
            if (isFinalParameter) continue;
            sb.append(", ");
        }
        return sb;
    }

    protected String serialize(Object value) {
        String stringRepresentation = String.valueOf(value);
        if (value instanceof String) {
            return "\"" + stringRepresentation + "\"";
        }
        return stringRepresentation;
    }
}

